/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonUiTestLibrary.fixtures.mainIdeWindow.toolWindowsPane.buildToolPane;

import com.intellij.remoterobot.RemoteRobot;
import com.intellij.remoterobot.data.RemoteComponent;
import com.intellij.remoterobot.fixtures.CommonContainerFixture;
import com.intellij.remoterobot.fixtures.DefaultXpath;
import com.intellij.remoterobot.fixtures.FixtureName;
import com.intellij.remoterobot.fixtures.JTreeFixture;
import com.intellij.remoterobot.fixtures.dataExtractor.RemoteText;
import com.intellij.remoterobot.search.locators.Locators;
import com.intellij.remoterobot.utils.RepeatUtilsKt;
import com.redhat.devtools.intellij.commonUiTestLibrary.fixtures.mainIdeWindow.toolWindowsPane.BuildView;
import com.redhat.devtools.intellij.commonUiTestLibrary.fixtures.mainIdeWindow.toolWindowsPane.ToolWindowsPane;
import com.redhat.devtools.intellij.commonUiTestLibrary.utils.textTranformation.TextUtils;
import java.time.Duration;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

@DefaultXpath(by="ToolWindowsPane type", xpath="//div[@accessiblename='Maven Tool Window']")
@FixtureName(name="Tool Windows Pane")
public class MavenBuildToolPane
extends CommonContainerFixture {
    private RemoteRobot remoteRobot;

    public MavenBuildToolPane(@NotNull RemoteRobot remoteRobot, @NotNull RemoteComponent remoteComponent) {
        super(remoteRobot, remoteComponent);
        this.remoteRobot = remoteRobot;
    }

    public void reloadAllMavenProjects() {
        this.actionButton(Locators.byXpath((String)"//div[@myicon='refresh.svg']"), Duration.ofSeconds(2L)).click();
    }

    public void collapseAll() {
        this.actionButton(Locators.byXpath((String)"//div[contains(@myvisibleactions, 'For')]//div[@myicon='collapseall.svg']"), Duration.ofSeconds(2L)).click();
    }

    public void buildProject(String lifecycle) {
        RepeatUtilsKt.waitFor((Duration)Duration.ofSeconds(30L), (Duration)Duration.ofSeconds(2L), (String)"The Maven target tree did not appear in 30 seconds.", () -> this.isMavenTreeVisible());
        this.mavenTargetTree().expandAll();
        ((RemoteText)this.mavenTargetTree().findAllText(lifecycle).get(0)).doubleClick();
        ((BuildView)((ToolWindowsPane)this.remoteRobot.find(ToolWindowsPane.class)).find(BuildView.class)).waitUntilBuildHasFinished();
    }

    public JTreeFixture mavenTargetTree() {
        return (JTreeFixture)this.find(JTreeFixture.class, JTreeFixture.Companion.byType(), Duration.ofSeconds(10L));
    }

    private boolean isMavenTreeVisible() {
        String treeContent = TextUtils.listOfRemoteTextToString(this.mavenTargetTree().findAllText());
        return !treeContent.toLowerCase(Locale.ROOT).contains("nothing") && !treeContent.equals("");
    }
}

