/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonUiTestLibrary.utils.screenshot;

import com.intellij.remoterobot.RemoteRobot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.imageio.ImageIO;

public class ScreenshotUtils {
    static final String screenshotLocation = "." + File.separator + "build" + File.separator + "screenshots" + File.separator;
    static final String screenshotFilename = ScreenshotUtils.getTimeNow("yyyy_MM_dd_HH_mm_ss");
    static final String filetype = "png";
    static final String screenshotPathname = screenshotLocation + screenshotFilename + "." + "png";

    public static File takeScreenshot(RemoteRobot remoteRobot) {
        try {
            BufferedImage screenshotBufferedImage = remoteRobot.getScreenshot();
            boolean doesScreenshotDirExists = Files.exists(Paths.get(screenshotLocation, new String[0]), new LinkOption[0]);
            if (!doesScreenshotDirExists) {
                Files.createDirectory(Paths.get(screenshotLocation, new String[0]), new FileAttribute[0]);
            }
            File screenshotFile = new File(screenshotPathname);
            ImageIO.write((RenderedImage)screenshotBufferedImage, filetype, screenshotFile);
            return screenshotFile;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getTimeNow(String timeFormat) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(timeFormat);
        LocalDateTime localTimeNow = LocalDateTime.now();
        return dateTimeFormatter.format(localTimeNow);
    }
}

