/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonUiTestLibrary.utils.testExtension;

import com.intellij.remoterobot.RemoteRobot;
import com.intellij.remoterobot.stepsProcessing.StepWorkerKt;
import com.intellij.remoterobot.utils.WaitForConditionTimeoutException;
import com.redhat.devtools.intellij.commonUiTestLibrary.UITestRunner;
import com.redhat.devtools.intellij.commonUiTestLibrary.fixtures.dialogs.FlatWelcomeFrame;
import com.redhat.devtools.intellij.commonUiTestLibrary.fixtures.dialogs.project.NewProjectDialogWizard;
import com.redhat.devtools.intellij.commonUiTestLibrary.fixtures.mainIdeWindow.MainIdeWindow;
import com.redhat.devtools.intellij.commonUiTestLibrary.utils.screenshot.ScreenshotUtils;
import java.time.Duration;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ScreenshotAfterTestFailExtension
implements AfterTestExecutionCallback {
    private RemoteRobot remoteRobot = UITestRunner.getRemoteRobot();

    public void afterTestExecution(ExtensionContext extensionContext) {
        boolean testFailed = extensionContext.getExecutionException().isPresent();
        if (testFailed) {
            StepWorkerKt.step((String)"Take a screenshot after a test has failed", () -> ScreenshotUtils.takeScreenshot(this.remoteRobot));
            StepWorkerKt.step((String)"Return to the 'Welcome Frame' dialog", () -> this.cleanAfterTestFail());
        }
    }

    private void cleanAfterTestFail() {
        try {
            NewProjectDialogWizard newProjectDialogWizard = (NewProjectDialogWizard)this.remoteRobot.find(NewProjectDialogWizard.class, Duration.ofSeconds(10L));
            newProjectDialogWizard.cancel();
            return;
        }
        catch (WaitForConditionTimeoutException newProjectDialogWizard) {
            try {
                this.remoteRobot.find(FlatWelcomeFrame.class, Duration.ofSeconds(10L));
                return;
            }
            catch (WaitForConditionTimeoutException e) {
                try {
                    ((MainIdeWindow)this.remoteRobot.find(MainIdeWindow.class, Duration.ofSeconds(10L))).closeProject();
                    return;
                }
                catch (WaitForConditionTimeoutException waitForConditionTimeoutException) {
                    return;
                }
            }
        }
    }
}

