/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonuitest.fixtures.dialogs;

import com.intellij.remoterobot.RemoteRobot;
import com.intellij.remoterobot.data.RemoteComponent;
import com.intellij.remoterobot.fixtures.CommonContainerFixture;
import com.intellij.remoterobot.fixtures.ComponentFixture;
import com.intellij.remoterobot.fixtures.ContainerFixture;
import com.intellij.remoterobot.fixtures.DefaultXpath;
import com.intellij.remoterobot.fixtures.FixtureName;
import com.intellij.remoterobot.fixtures.JButtonFixture;
import com.intellij.remoterobot.fixtures.JListFixture;
import com.intellij.remoterobot.fixtures.JPopupMenuFixture;
import com.intellij.remoterobot.search.locators.Locator;
import com.intellij.remoterobot.search.locators.Locators;
import com.intellij.remoterobot.utils.UtilsKt;
import com.intellij.remoterobot.utils.WaitForConditionTimeoutException;
import com.redhat.devtools.intellij.commonuitest.UITestRunner;
import com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.errors.IdeFatalErrorsDialog;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@DefaultXpath(by="FlatWelcomeFrame type", xpath="//div[@class='FlatWelcomeFrame']")
@FixtureName(name="Welcome To IntelliJ IDEA Dialog")
public class FlatWelcomeFrame
extends CommonContainerFixture {
    private static final Logger LOGGER = Logger.getLogger(FlatWelcomeFrame.class.getName());
    private UITestRunner.IdeaVersion intelliJVersion = UITestRunner.getIdeaVersion();

    public FlatWelcomeFrame(@NotNull RemoteRobot remoteRobot, @NotNull RemoteComponent remoteComponent) {
        super(remoteRobot, remoteComponent);
    }

    public void createNewProject() {
        this.clickOnLink("New Project");
    }

    public void clickOnLink(String label) {
        if (this.intelliJVersion.toInt() >= 20203) {
            this.welcomeFrameLink(label).click();
        } else {
            this.actionLink(label).click();
        }
    }

    public void clearWorkspace() {
        List jListFixtures = this.jLists(Locators.byXpath((String)"//div[@accessiblename='Recent Projects']"));
        while (!jListFixtures.isEmpty() && ((JListFixture)jListFixtures.get(0)).findAllText().size() != 1) {
            JListFixture recentProjectsList = (JListFixture)jListFixtures.get(0);
            recentProjectsList.runJs("const horizontal_offset = component.getWidth()-22;\nrobot.click(component, new Point(horizontal_offset, 22), MouseButton.LEFT_BUTTON, 1);");
            if (this.intelliJVersion.toInt() < 20203) continue;
            JPopupMenuFixture contextMenu = (JPopupMenuFixture)this.jPopupMenus(JPopupMenuFixture.Companion.byType()).get(0);
            contextMenu.select(new String[]{"Remove from Recent Projects"});
        }
        try {
            String pathToDirToMakeEmpty = System.getProperty("user.home") + File.separator + "IdeaProjects";
            boolean doesProjectDirExists = Files.exists(Paths.get(pathToDirToMakeEmpty, new String[0]), new LinkOption[0]);
            if (doesProjectDirExists) {
                FileUtils.cleanDirectory((File)new File(pathToDirToMakeEmpty));
            } else {
                Files.createDirectory(Paths.get(pathToDirToMakeEmpty, new String[0]), new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void clearExceptions() {
        try {
            this.ideErrorsIcon().click();
        }
        catch (WaitForConditionTimeoutException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
        ((IdeFatalErrorsDialog)this.find(IdeFatalErrorsDialog.class, Duration.ofSeconds(10L))).clearAll();
    }

    private JButtonFixture welcomeFrameLink(String label) {
        if (UtilsKt.hasAnyComponent((ContainerFixture)this, (Locator)Locators.byXpath((String)"//div[@class='NewRecentProjectPanel']"))) {
            return this.button(Locators.byXpath((String)("//div[@class='JBOptionButton' and @text='" + label + "']")), Duration.ofSeconds(2L));
        }
        return this.button(Locators.byXpath((String)("//div[@class='NonOpaquePanel'][./div[@text='" + label + "']]")), Duration.ofSeconds(2L));
    }

    private ComponentFixture ideErrorsIcon() {
        return (ComponentFixture)this.find(ComponentFixture.class, Locators.byXpath((String)"//div[@class='IdeErrorsIcon']"), Duration.ofSeconds(10L));
    }
}

