/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonuitest.utils.screenshot;

import com.intellij.remoterobot.RemoteRobot;
import com.redhat.devtools.intellij.commonuitest.exceptions.UITestException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class ScreenshotUtils {
    static final String SCREENSHOT_LOCATION = "." + File.separator + "build" + File.separator + "screenshots" + File.separator;
    static final String SCREENSHOT_FILENAME = ScreenshotUtils.getTimeNow("yyyy_MM_dd_HH_mm_ss");
    static final String FILETYPE = "png";
    static final String SCREENSHOT_PATHNAME = SCREENSHOT_LOCATION + SCREENSHOT_FILENAME + "." + "png";
    private static final Logger LOGGER = Logger.getLogger(ScreenshotUtils.class.getName());

    private ScreenshotUtils() {
        throw new UITestException("Screenshot utility class contains static utilities and cannot be instantiated.");
    }

    public static File takeScreenshot(RemoteRobot remoteRobot) {
        try {
            BufferedImage screenshotBufferedImage = remoteRobot.getScreenshot();
            boolean doesScreenshotDirExists = Files.exists(Paths.get(SCREENSHOT_LOCATION, new String[0]), new LinkOption[0]);
            if (!doesScreenshotDirExists) {
                Files.createDirectory(Paths.get(SCREENSHOT_LOCATION, new String[0]), new FileAttribute[0]);
            }
            File screenshotFile = new File(SCREENSHOT_PATHNAME);
            ImageIO.write((RenderedImage)screenshotBufferedImage, FILETYPE, screenshotFile);
            return screenshotFile;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    private static String getTimeNow(String timeFormat) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(timeFormat);
        LocalDateTime localTimeNow = LocalDateTime.now();
        return dateTimeFormatter.format(localTimeNow);
    }
}

