/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonuitest;

import com.intellij.remoterobot.RemoteRobot;
import com.intellij.remoterobot.stepsProcessing.StepLogger;
import com.intellij.remoterobot.stepsProcessing.StepProcessor;
import com.intellij.remoterobot.stepsProcessing.StepWorker;
import com.intellij.remoterobot.stepsProcessing.StepWorkerKt;
import com.intellij.remoterobot.utils.RepeatUtilsKt;
import com.intellij.remoterobot.utils.WaitForConditionTimeoutException;
import com.redhat.devtools.intellij.commonuitest.exceptions.UITestException;
import com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.FlatWelcomeFrame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UITestRunner {
    private static final int DEFAULT_PORT = 8580;
    private static final String ACCEPTED_SOURCE_LOCATION = "accepted";
    private static final String COPY_ACCEPTED_FILE_STEP_DESCRIPTION = "Copy the 'accepted' file to the appropriate location";
    private static final Logger LOGGER = Logger.getLogger(UITestRunner.class.getName());
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    private static final String USER_HOME = System.getProperty("user.home");
    private static RemoteRobot remoteRobot = null;
    private static Process ideProcess;
    private static IdeaVersion ideaVersion;

    public static RemoteRobot runIde(IdeaVersion ideaVersion, int port) {
        StepWorker.registerProcessor((StepProcessor)new StepLogger());
        return (RemoteRobot)StepWorkerKt.step((String)("Start IntelliJ Idea ('" + ideaVersion.toString() + "') listening on port " + port), () -> {
            UITestRunner.ideaVersion = ideaVersion;
            UITestRunner.makeSureAllTermsAndConditionsAreAccepted();
            String fileExtension = OS_NAME.contains("windows") ? ".bat" : "";
            ProcessBuilder pb = new ProcessBuilder("." + File.separator + "gradlew" + fileExtension, "runIdeForUiTests", "-PideaVersion=" + ideaVersion.toString(), "-Drobot-server.port=" + port);
            try {
                ideProcess = pb.start();
                UITestRunner.waitUntilIntelliJStarts(port);
                remoteRobot = UITestRunner.getRemoteRobotConnection(port);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
            ((FlatWelcomeFrame)remoteRobot.find(FlatWelcomeFrame.class, Duration.ofSeconds(10L))).clearWorkspace();
            return remoteRobot;
        });
    }

    public static RemoteRobot runIde(IdeaVersion ideaVersion) {
        return UITestRunner.runIde(ideaVersion, 8580);
    }

    public static void closeIde() {
        ideProcess.destroy();
    }

    public static IdeaVersion getIdeaVersion() {
        return ideaVersion;
    }

    public static RemoteRobot getRemoteRobot() {
        return remoteRobot;
    }

    public static RemoteRobot getRemoteRobotConnection(int port) {
        return (RemoteRobot)StepWorkerKt.step((String)("Create an instance of the RemoteRobot listening on port " + port), () -> {
            RemoteRobot remoteRobot = new RemoteRobot("http://127.0.0.1:" + port);
            for (int i = 0; i < 60; ++i) {
                try {
                    remoteRobot.find(FlatWelcomeFrame.class);
                    continue;
                }
                catch (WaitForConditionTimeoutException e) {
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e2) {
                        LOGGER.log(Level.SEVERE, e2.getMessage(), e2);
                        Thread.currentThread().interrupt();
                    }
                }
            }
            return remoteRobot;
        });
    }

    private static void makeSureAllTermsAndConditionsAreAccepted() {
        if (OS_NAME.contains("linux")) {
            StepWorkerKt.step((String)"Copy the 'prefs.xml' file to the appropriate location", () -> {
                String prefsXmlSourceLocation = "prefs.xml";
                String prefsXmlDir = USER_HOME + "/.java/.userPrefs/jetbrains/_!(!!cg\"p!(}!}@\"j!(k!|w\"w!'8!b!\"p!':!e@==";
                UITestRunner.createDirectoryHierarchy(prefsXmlDir);
                UITestRunner.copyFileFromJarResourceDir(prefsXmlSourceLocation, prefsXmlDir + "/prefs.xml");
            });
            StepWorkerKt.step((String)COPY_ACCEPTED_FILE_STEP_DESCRIPTION, () -> {
                String acceptedDir = USER_HOME + "/.local/share/JetBrains/consentOptions";
                UITestRunner.createDirectoryHierarchy(acceptedDir);
                UITestRunner.copyFileFromJarResourceDir(ACCEPTED_SOURCE_LOCATION, acceptedDir + "/accepted");
            });
        } else if (OS_NAME.contains("os x")) {
            StepWorkerKt.step((String)"Copy the 'com.apple.java.util.prefs.plist' file to the appropriate location", () -> {
                String plistSourceLocation = "com.apple.java.util.prefs.plist";
                String plistDir = USER_HOME + "/Library/Preferences";
                UITestRunner.copyFileFromJarResourceDir(plistSourceLocation, plistDir + "/com.apple.java.util.prefs.plist");
            });
            StepWorkerKt.step((String)COPY_ACCEPTED_FILE_STEP_DESCRIPTION, () -> {
                String acceptedDir = USER_HOME + "/Library/Application Support/JetBrains/consentOptions";
                UITestRunner.createDirectoryHierarchy(acceptedDir);
                UITestRunner.copyFileFromJarResourceDir(ACCEPTED_SOURCE_LOCATION, acceptedDir + "/accepted");
                ProcessBuilder pb = new ProcessBuilder("/usr/bin/killall", "cfprefsd");
                try {
                    Process p = pb.start();
                    p.waitFor();
                }
                catch (IOException | InterruptedException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    Thread.currentThread().interrupt();
                }
            });
        } else if (OS_NAME.contains("windows")) {
            StepWorkerKt.step((String)COPY_ACCEPTED_FILE_STEP_DESCRIPTION, () -> {
                String acceptedDir = USER_HOME + "\\AppData\\Roaming\\JetBrains\\consentOptions";
                UITestRunner.createDirectoryHierarchy(acceptedDir);
                UITestRunner.copyFileFromJarResourceDir(ACCEPTED_SOURCE_LOCATION, acceptedDir + "\\accepted");
            });
            StepWorkerKt.step((String)"Create appropriate registry entries", () -> {
                String registryPath = "HKCU:\\Software\\JavaSoft\\Prefs\\jetbrains\\privacy_policy";
                String powershellLocation = "C:\\Windows\\system32\\WindowsPowerShell\\v1.0\\powershell.exe";
                ProcessBuilder pb1 = new ProcessBuilder(powershellLocation, "New-Item", "-Path", registryPath, "-Force");
                ProcessBuilder pb2 = new ProcessBuilder(powershellLocation, "New-ItemProperty", "-Path", registryPath, "-Name", "accepted_version", "-Value", "'2.1'");
                try {
                    Process p1 = pb1.start();
                    p1.waitFor();
                    Process p2 = pb2.start();
                    p2.waitFor();
                }
                catch (IOException | InterruptedException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    Thread.currentThread().interrupt();
                }
            });
        }
    }

    private static void waitUntilIntelliJStarts(int port) {
        RepeatUtilsKt.waitFor((Duration)Duration.ofSeconds(600L), (Duration)Duration.ofSeconds(3L), (String)"The IntelliJ Idea did not start in 10 minutes.", () -> UITestRunner.isIntelliJUIVisible(port));
    }

    private static boolean isIntelliJUIVisible(int port) {
        return UITestRunner.isHostOnIpAndPortAccessible("127.0.0.1", port);
    }

    private static boolean isHostOnIpAndPortAccessible(String ip, int port) {
        InetSocketAddress sockaddr = new InetSocketAddress(ip, port);
        try (Socket socket = new Socket();){
            UITestRunner.connectToHost(socket, sockaddr);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static void connectToHost(Socket socket, SocketAddress sockaddr) throws IOException {
        socket.connect(sockaddr, 10000);
        try {
            socket.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private static void createDirectoryHierarchy(String location) {
        Path path = Paths.get(location, new String[0]);
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private static void copyFileFromJarResourceDir(String sourceFileLocation, String destFileLocation) {
        InputStream resourceStream = UITestRunner.class.getClassLoader().getResourceAsStream(sourceFileLocation);
        try (FileOutputStream outStream = new FileOutputStream(new File(destFileLocation));){
            byte[] buffer = new byte[resourceStream.available()];
            int count = resourceStream.read(buffer);
            if (count == 0) {
                throw new UITestException("Reading from buffer was unsuccessful.");
            }
            ((OutputStream)outStream).write(buffer);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public static enum IdeaVersion {
        COMMUNITY_V_2020_2("IC-2020.2"),
        COMMUNITY_V_2020_3("IC-2020.3"),
        ULTIMATE_V_2020_2("IU-2020.2"),
        ULTIMATE_V_2020_3("IU-2020.3");

        private final String ideaVersionStringRepresentation;

        private IdeaVersion(String ideaVersionStringRepresentation) {
            this.ideaVersionStringRepresentation = ideaVersionStringRepresentation;
        }

        public String toString() {
            return this.ideaVersionStringRepresentation;
        }

        public int toInt() {
            String ideaVersion = this.ideaVersionStringRepresentation.substring(3).replace(".", "");
            return Integer.parseInt(ideaVersion);
        }
    }
}

