/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonuitest.utils.project;

import com.intellij.remoterobot.RemoteRobot;
import com.redhat.devtools.intellij.commonuitest.exceptions.UITestException;
import com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.FlatWelcomeFrame;
import com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.information.TipDialog;
import com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.project.NewProjectDialogWizard;
import com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.project.pages.AbstractNewProjectFinalPage;
import com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.project.pages.JavaNewProjectFinalPage;
import com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.project.pages.MavenGradleNewProjectFinalPage;
import com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.project.pages.NewProjectFirstPage;
import com.redhat.devtools.intellij.commonuitest.fixtures.mainidewindow.MainIdeWindow;
import com.redhat.devtools.intellij.commonuitest.fixtures.mainidewindow.idestatusbar.IdeStatusBar;
import java.time.Duration;

public class CreateCloseUtils {
    public static void createNewProject(RemoteRobot remoteRobot, String projectName, NewProjectType newProjectType) {
        CreateCloseUtils.openNewProjectDialogFromWelcomeDialog(remoteRobot);
        NewProjectDialogWizard newProjectDialogWizard = (NewProjectDialogWizard)remoteRobot.find(NewProjectDialogWizard.class, Duration.ofSeconds(10L));
        NewProjectFirstPage newProjectFirstPage = (NewProjectFirstPage)newProjectDialogWizard.find(NewProjectFirstPage.class, Duration.ofSeconds(10L));
        newProjectFirstPage.selectNewProjectType(newProjectType.toString());
        newProjectFirstPage.setProjectSdkIfAvailable("11");
        newProjectDialogWizard.next();
        if (newProjectType.equals((Object)NewProjectType.PLAIN_JAVA)) {
            newProjectDialogWizard.next();
        }
        AbstractNewProjectFinalPage finalPage = CreateCloseUtils.getFinalPage(newProjectDialogWizard, newProjectType);
        finalPage.setProjectName(projectName);
        newProjectDialogWizard.finish();
        IdeStatusBar ideStatusBar = (IdeStatusBar)remoteRobot.find(IdeStatusBar.class, Duration.ofSeconds(10L));
        ideStatusBar.waitUntilProjectImportIsComplete();
        TipDialog.closeTipDialogIfItAppears(remoteRobot);
        MainIdeWindow mainIdeWindow = (MainIdeWindow)remoteRobot.find(MainIdeWindow.class, Duration.ofSeconds(5L));
        mainIdeWindow.maximizeIdeWindow();
        ideStatusBar.waitUntilAllBgTasksFinish();
    }

    public static void openNewProjectDialogFromWelcomeDialog(RemoteRobot remoteRobot) {
        FlatWelcomeFrame flatWelcomeFrame = (FlatWelcomeFrame)remoteRobot.find(FlatWelcomeFrame.class, Duration.ofSeconds(10L));
        flatWelcomeFrame.createNewProject();
    }

    public static void closeProject(RemoteRobot remoteRobot) {
        MainIdeWindow mainIdeWindow = (MainIdeWindow)remoteRobot.find(MainIdeWindow.class, Duration.ofSeconds(10L));
        mainIdeWindow.closeProject();
    }

    public static AbstractNewProjectFinalPage getFinalPage(NewProjectDialogWizard newProjectDialogWizard, NewProjectType newProjectType) {
        switch (newProjectType) {
            case PLAIN_JAVA: {
                return (AbstractNewProjectFinalPage)newProjectDialogWizard.find(JavaNewProjectFinalPage.class, Duration.ofSeconds(10L));
            }
            case MAVEN: 
            case GRADLE: {
                return (AbstractNewProjectFinalPage)newProjectDialogWizard.find(MavenGradleNewProjectFinalPage.class, Duration.ofSeconds(10L));
            }
        }
        throw new UITestException("Unsupported project type.");
    }

    public static enum NewProjectType {
        PLAIN_JAVA("Java"),
        MAVEN("Maven"),
        GRADLE("Gradle");

        private final String projectType;

        private NewProjectType(String projectType) {
            this.projectType = projectType;
        }

        public String toString() {
            return this.projectType;
        }
    }
}

