/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonuitest.fixtures.dialogs;

import com.intellij.remoterobot.RemoteRobot;
import com.intellij.remoterobot.data.RemoteComponent;
import com.intellij.remoterobot.fixtures.CommonContainerFixture;
import com.intellij.remoterobot.fixtures.ComponentFixture;
import com.intellij.remoterobot.fixtures.ContainerFixture;
import com.intellij.remoterobot.fixtures.DefaultXpath;
import com.intellij.remoterobot.fixtures.FixtureName;
import com.intellij.remoterobot.fixtures.HeavyWeightWindowFixture;
import com.intellij.remoterobot.fixtures.JButtonFixture;
import com.intellij.remoterobot.fixtures.JLabelFixture;
import com.intellij.remoterobot.fixtures.JListFixture;
import com.intellij.remoterobot.fixtures.JPopupMenuFixture;
import com.intellij.remoterobot.fixtures.JTreeFixture;
import com.intellij.remoterobot.search.locators.Locator;
import com.intellij.remoterobot.search.locators.Locators;
import com.intellij.remoterobot.utils.UtilsKt;
import com.intellij.remoterobot.utils.WaitForConditionTimeoutException;
import com.redhat.devtools.intellij.commonuitest.UITestRunner;
import com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.errors.IdeFatalErrorsDialog;
import com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.information.TipDialog;
import com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.settings.SettingsDialog;
import com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.settings.pages.NotificationsPage;
import com.redhat.devtools.intellij.commonuitest.utils.constants.XPathDefinitions;
import com.redhat.devtools.intellij.commonuitest.utils.internalerror.IdeInternalErrorUtils;
import com.redhat.devtools.intellij.commonuitest.utils.runner.IntelliJVersion;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@DefaultXpath(by="FlatWelcomeFrame type", xpath="//div[@class='FlatWelcomeFrame']")
@FixtureName(name="Welcome To IntelliJ IDEA Dialog")
public class FlatWelcomeFrame
extends CommonContainerFixture {
    private static final Logger LOGGER = Logger.getLogger(FlatWelcomeFrame.class.getName());
    private static final String PROJECTS_BUTTON = "Projects";
    private static final String TIP_OF_THE_DAY = "Tip of the Day";
    private final RemoteRobot remoteRobot;
    private final IntelliJVersion intelliJVersion;
    private final int ideaVersion;

    public FlatWelcomeFrame(@NotNull RemoteRobot remoteRobot, @NotNull RemoteComponent remoteComponent) {
        super(remoteRobot, remoteComponent);
        this.remoteRobot = remoteRobot;
        this.intelliJVersion = UITestRunner.getIdeaVersion();
        this.ideaVersion = this.intelliJVersion.toInt();
    }

    public void createNewProject() {
        this.clickOnLink("New Project");
    }

    public void clickOnLink(String label) {
        if (this.ideaVersion >= 20203) {
            this.welcomeFrameLink(label).click();
        } else {
            this.actionLink(label).click();
        }
    }

    public void clearWorkspace() {
        List jListFixtures = this.jLists(Locators.byXpath((String)"//div[@accessiblename='Recent Projects']"));
        for (int i = 0; i < this.projectsCount(); ++i) {
            List jPopupMenuFixtures;
            JListFixture recentProjectsList = (JListFixture)jListFixtures.get(0);
            recentProjectsList.runJs("const horizontal_offset = component.getWidth()-22;\nrobot.click(component, new Point(horizontal_offset, 22), MouseButton.LEFT_BUTTON, 1);");
            if (this.ideaVersion < 20203 || (jPopupMenuFixtures = this.jPopupMenus(JPopupMenuFixture.Companion.byType())).isEmpty()) continue;
            JPopupMenuFixture contextMenu = (JPopupMenuFixture)jPopupMenuFixtures.get(0);
            contextMenu.select(new String[]{"Remove from Recent Projects"});
        }
        try {
            String pathToDirToMakeEmpty = System.getProperty("user.home") + File.separator + "IdeaProjects";
            boolean doesProjectDirExists = Files.exists(Paths.get(pathToDirToMakeEmpty, new String[0]), new LinkOption[0]);
            if (doesProjectDirExists) {
                FileUtils.cleanDirectory((File)new File(pathToDirToMakeEmpty));
            } else {
                Files.createDirectory(Paths.get(pathToDirToMakeEmpty, new String[0]), new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void clearExceptions() {
        try {
            this.ideErrorsIcon().click();
            ((IdeFatalErrorsDialog)this.find(IdeFatalErrorsDialog.class, Duration.ofSeconds(10L))).clearAll();
        }
        catch (WaitForConditionTimeoutException e) {
            LOGGER.log(Level.INFO, e.getMessage(), e);
            try {
                ((IdeFatalErrorsDialog)this.find(IdeFatalErrorsDialog.class, Duration.ofSeconds(10L))).clearAll();
            }
            catch (Exception e2) {
                LOGGER.log(Level.INFO, e.getMessage(), e2);
            }
        }
    }

    public void openSettingsDialog() {
        if (this.ideaVersion <= 20202) {
            this.clickOnLink("Configure");
            HeavyWeightWindowFixture heavyWeightWindowFixture = (HeavyWeightWindowFixture)this.find(HeavyWeightWindowFixture.class, Duration.ofSeconds(5L));
            heavyWeightWindowFixture.findText("Preferences").click();
        } else if (this.ideaVersion <= 20212) {
            JListFixture jListFixture = (JListFixture)this.remoteRobot.find(JListFixture.class, Locators.byXpath((String)"//div[@class='JBList']"));
            jListFixture.clickItem("Customize", false);
            ((ContainerFixture)this.remoteRobot.find(ContainerFixture.class, Locators.byXpath((String)"//div[@class='DialogPanel']"))).findText("All settings\u2026").click();
        } else {
            JTreeFixture jTreeFixture = (JTreeFixture)this.remoteRobot.find(JTreeFixture.class, Locators.byXpath((String)"//div[@class='Tree']"));
            jTreeFixture.findText("Customize").click();
            ((ContainerFixture)this.remoteRobot.find(ContainerFixture.class, Locators.byXpath((String)"//div[@class='DialogPanel']"))).findText("All settings\u2026").click();
        }
    }

    public TipDialog openTipDialog() {
        if (this.ideaVersion <= 20202) {
            this.clickOnLink("Get Help");
            HeavyWeightWindowFixture heavyWeightWindowFixture = (HeavyWeightWindowFixture)this.find(HeavyWeightWindowFixture.class, Duration.ofSeconds(5L));
            heavyWeightWindowFixture.findText(TIP_OF_THE_DAY).click();
        } else if (this.ideaVersion <= 20203) {
            this.actionLink("Help").click();
            HeavyWeightWindowFixture heavyWeightWindowFixture = (HeavyWeightWindowFixture)this.find(HeavyWeightWindowFixture.class, Duration.ofSeconds(5L));
            heavyWeightWindowFixture.findText(TIP_OF_THE_DAY).click();
        } else if (this.ideaVersion <= 20212) {
            JListFixture jListFixture = (JListFixture)this.remoteRobot.find(JListFixture.class, Locators.byXpath((String)"//div[@class='JBList']"));
            jListFixture.findText("Learn IntelliJ IDEA").click();
            ((JLabelFixture)this.remoteRobot.find(JLabelFixture.class, Locators.byXpath((String)"//div[@text='Tip of the Day']"))).click();
        } else {
            IdeInternalErrorUtils.clearWindowsErrorsIfTheyAppear(this.remoteRobot);
            JTreeFixture jTreeFixture = (JTreeFixture)this.remoteRobot.find(JTreeFixture.class, Locators.byXpath((String)"//div[@class='Tree']"));
            jTreeFixture.findText("Learn IntelliJ IDEA").click();
            FlatWelcomeFrame flatWelcomeFrame = (FlatWelcomeFrame)this.remoteRobot.find(FlatWelcomeFrame.class);
            flatWelcomeFrame.findText(TIP_OF_THE_DAY).click();
        }
        return (TipDialog)this.remoteRobot.find(TipDialog.class, Duration.ofSeconds(10L));
    }

    public void disableNotifications() {
        this.openSettingsDialog();
        SettingsDialog settingsDialog = (SettingsDialog)this.remoteRobot.find(SettingsDialog.class, Duration.ofSeconds(5L));
        settingsDialog.navigateTo("Appearance & Behavior", "Notifications");
        NotificationsPage notificationsPage = (NotificationsPage)this.remoteRobot.find(NotificationsPage.class, Duration.ofSeconds(5L));
        notificationsPage.toggleNotifications(false);
        settingsDialog.ok();
        this.switchToProjectsPage();
    }

    public void preventTipDialogFromOpening() {
        TipDialog tipDialog = this.openTipDialog();
        tipDialog.dontShowTipsCheckBox().setValue(true);
        tipDialog.close();
        this.switchToProjectsPage();
    }

    public void switchToProjectsPage() {
        if (this.ideaVersion >= 20213) {
            JTreeFixture jTreeFixture = (JTreeFixture)this.remoteRobot.find(JTreeFixture.class, Locators.byXpath((String)"//div[@class='Tree']"));
            jTreeFixture.findText(PROJECTS_BUTTON).click();
        } else if (this.ideaVersion >= 20203) {
            JListFixture jListFixture = (JListFixture)this.remoteRobot.find(JListFixture.class, Locators.byXpath((String)"//div[@class='JBList']"));
            jListFixture.clickItem(PROJECTS_BUTTON, false);
        }
    }

    private int projectsCount() {
        try {
            ContainerFixture projectWrapper = (ContainerFixture)this.find(ContainerFixture.class, Locators.byXpath((String)"//div[@class='NewRecentProjectPanel']"));
            JListFixture projectList = (JListFixture)projectWrapper.find(JListFixture.class, Locators.byXpath((String)"//div[@class='MyList']"));
            return projectList.collectItems().size();
        }
        catch (WaitForConditionTimeoutException e) {
            return 0;
        }
    }

    private JButtonFixture welcomeFrameLink(String label) {
        if (UtilsKt.hasAnyComponent((ContainerFixture)this, (Locator)Locators.byXpath((String)"//div[@class='NewRecentProjectPanel']"))) {
            return this.button(Locators.byXpath((String)XPathDefinitions.jBOptionButton(label)), Duration.ofSeconds(2L));
        }
        return this.button(Locators.byXpath((String)XPathDefinitions.nonOpaquePanel(label)), Duration.ofSeconds(2L));
    }

    private ComponentFixture ideErrorsIcon() {
        return (ComponentFixture)this.find(ComponentFixture.class, Locators.byXpath((String)"//div[@class='IdeErrorsIcon']"), Duration.ofSeconds(10L));
    }
}

