/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.project.pages;

import com.intellij.remoterobot.RemoteRobot;
import com.intellij.remoterobot.data.RemoteComponent;
import com.intellij.remoterobot.fixtures.CommonContainerFixture;
import com.intellij.remoterobot.fixtures.ComponentFixture;
import com.intellij.remoterobot.fixtures.DefaultXpath;
import com.intellij.remoterobot.fixtures.FixtureName;
import com.intellij.remoterobot.fixtures.JTextFieldFixture;
import com.intellij.remoterobot.search.locators.Locators;
import com.redhat.devtools.intellij.commonuitest.UITestRunner;
import com.redhat.devtools.intellij.commonuitest.exceptions.UITestException;
import com.redhat.devtools.intellij.commonuitest.utils.texttranformation.TextUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@DefaultXpath(by="MyDialog type", xpath="//div[@class='DialogRootPane']")
@FixtureName(name="New Project Dialog")
public abstract class AbstractNewProjectFinalPage
extends CommonContainerFixture {
    protected AbstractNewProjectFinalPage(@NotNull RemoteRobot remoteRobot, @NotNull RemoteComponent remoteComponent) {
        super(remoteRobot, remoteComponent);
    }

    public String getProjectName() {
        if (UITestRunner.getIdeaVersionInt() >= 20221) {
            return ((JTextFieldFixture)this.textFields(Locators.byXpath((String)"//div[@class='JBTextField']")).get(0)).getText();
        }
        return ((JTextFieldFixture)this.textFields(JTextFieldFixture.Companion.byType()).get(0)).getText();
    }

    public void setProjectName(String projectName) {
        if (UITestRunner.getIdeaVersionInt() >= 20221) {
            ((JTextFieldFixture)this.textFields(Locators.byXpath((String)"//div[@class='JBTextField']")).get(0)).setText(projectName);
        } else {
            ((JTextFieldFixture)this.textFields(JTextFieldFixture.Companion.byType()).get(0)).setText(projectName);
        }
    }

    public String getProjectLocation() {
        if (UITestRunner.getIdeaVersionInt() >= 20221) {
            return ((JTextFieldFixture)this.find(JTextFieldFixture.class, Locators.byXpath((String)"//div[@class='ExtendableTextField']"))).getText();
        }
        return ((JTextFieldFixture)this.textFields(JTextFieldFixture.Companion.byType()).get(1)).getText();
    }

    public void setProjectLocation(String projectLocation) {
        if (UITestRunner.getIdeaVersionInt() >= 20221) {
            ((JTextFieldFixture)this.find(JTextFieldFixture.class, Locators.byXpath((String)"//div[@class='ExtendableTextField']"))).setText(projectLocation);
        } else {
            ((JTextFieldFixture)this.textFields(JTextFieldFixture.Companion.byType()).get(1)).setText(projectLocation);
        }
    }

    public void openAdvanceSettings() {
        if (!this.isAdvancedSettingsOpened()) {
            ((ComponentFixture)this.find(ComponentFixture.class, Locators.byXpath((String)"//div[@class='CollapsibleTitledSeparator']"))).click();
        }
    }

    public void closeAdvanceSettings() {
        if (this.isAdvancedSettingsOpened()) {
            ((ComponentFixture)this.find(ComponentFixture.class, Locators.byXpath((String)"//div[@class='CollapsibleTitledSeparator']"))).click();
        }
    }

    private boolean isAdvancedSettingsOpened() {
        List ss = this.findAll(ComponentFixture.class, Locators.byXpath((String)"//div[@class='CollapsibleTitledSeparator']/../*"));
        for (int i = 0; i < ss.size(); ++i) {
            if (!TextUtils.listOfRemoteTextToString(((ComponentFixture)ss.get(i)).findAllText()).contains("Advanced Settings")) continue;
            return i != ss.size() - 1;
        }
        throw new UITestException("Wizard does not contain 'Advanced Settings' section.");
    }

    public static enum ProjectFormatType {
        IDEA_DIRECTORY_BASED(".idea"),
        IPR_FILE_BASED(".ipr");

        private final String textRepresentation;

        private ProjectFormatType(String textRepresentation) {
            this.textRepresentation = textRepresentation;
        }

        public String toString() {
            return this.textRepresentation;
        }
    }
}

