/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonuitest.fixtures.mainidewindow.toolwindowspane;

import com.intellij.remoterobot.RemoteRobot;
import com.intellij.remoterobot.data.RemoteComponent;
import com.intellij.remoterobot.fixtures.DefaultXpath;
import com.intellij.remoterobot.fixtures.FixtureName;
import com.intellij.remoterobot.fixtures.JButtonFixture;
import com.intellij.remoterobot.search.locators.Locators;
import com.redhat.devtools.intellij.commonuitest.fixtures.mainidewindow.toolwindowspane.AbstractToolWinPane;
import com.redhat.devtools.intellij.commonuitest.fixtures.mainidewindow.toolwindowspane.ProjectExplorer;
import com.redhat.devtools.intellij.commonuitest.fixtures.mainidewindow.toolwindowspane.buildtoolpane.GradleBuildToolPane;
import com.redhat.devtools.intellij.commonuitest.fixtures.mainidewindow.toolwindowspane.buildtoolpane.MavenBuildToolPane;
import com.redhat.devtools.intellij.commonuitest.utils.constants.XPathDefinitions;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;

@DefaultXpath(by="ToolWindowsPane type", xpath="//div[@class='ToolWindowsPane']")
@FixtureName(name="Tool Windows Pane")
public class ToolWindowsPane
extends AbstractToolWinPane {
    public ToolWindowsPane(@NotNull RemoteRobot remoteRobot, @NotNull RemoteComponent remoteComponent) {
        super(remoteRobot, remoteComponent);
    }

    @Override
    public ProjectExplorer openProjectExplorer() {
        return this.togglePane("Project", ProjectExplorer.class, true);
    }

    @Override
    public void closeProjectExplorer() {
        this.togglePane("Project", ProjectExplorer.class, false);
    }

    @Override
    public MavenBuildToolPane openMavenBuildToolPane() {
        return this.togglePane("Maven", MavenBuildToolPane.class, true);
    }

    @Override
    public void closeMavenBuildToolPane() {
        this.togglePane("Maven", MavenBuildToolPane.class, false);
    }

    @Override
    public GradleBuildToolPane openGradleBuildToolPane() {
        return this.togglePane("Gradle", GradleBuildToolPane.class, true);
    }

    @Override
    public void closeGradleBuildToolPane() {
        this.togglePane("Gradle", GradleBuildToolPane.class, false);
    }

    @Override
    public JButtonFixture stripeButton(String label, boolean isPaneOpened) {
        if (isPaneOpened) {
            if (label.equals("Maven") || label.equals("Gradle")) {
                return this.button(Locators.byXpath((String)XPathDefinitions.toolWindowSvg(label)), Duration.ofSeconds(2L));
            }
            if (label.equals("Project")) {
                return this.button(Locators.byXpath((String)"//div[@tooltiptext='Project']"), Duration.ofSeconds(2L));
            }
        }
        return this.button(Locators.byXpath((String)XPathDefinitions.label(label)), Duration.ofSeconds(2L));
    }
}

