/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.project.pages;

import com.intellij.remoterobot.RemoteRobot;
import com.intellij.remoterobot.data.RemoteComponent;
import com.intellij.remoterobot.fixtures.ComboBoxFixture;
import com.intellij.remoterobot.fixtures.ContainerFixture;
import com.intellij.remoterobot.fixtures.DefaultXpath;
import com.intellij.remoterobot.fixtures.FixtureName;
import com.intellij.remoterobot.fixtures.JTextFieldFixture;
import com.intellij.remoterobot.search.locators.Locators;
import com.intellij.remoterobot.stepsProcessing.StepWorkerKt;
import com.redhat.devtools.intellij.commonuitest.UITestRunner;
import com.redhat.devtools.intellij.commonuitest.exceptions.UITestException;
import com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.project.pages.AbstractNewProjectFinalPage;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;

@DefaultXpath(by="MyDialog type", xpath="//div[@class='DialogRootPane']")
@FixtureName(name="New Project Dialog")
public class JavaNewProjectFinalPage
extends AbstractNewProjectFinalPage {
    public JavaNewProjectFinalPage(@NotNull RemoteRobot remoteRobot, @NotNull RemoteComponent remoteComponent) {
        super(remoteRobot, remoteComponent);
    }

    public void openMoreSettings() {
        StepWorkerKt.step((String)"Open the 'More settings' options", () -> {
            boolean isAlreadyOpened = this.isMoreSettingOpened();
            if (!isAlreadyOpened) {
                this.jLabel("More Settings").click();
            }
        });
    }

    public void closeMoreSettings() {
        StepWorkerKt.step((String)"Close the 'More settings' options", () -> {
            boolean isAlreadyOpened = this.isMoreSettingOpened();
            if (isAlreadyOpened) {
                this.jLabel("More Settings").click();
            }
        });
    }

    public String getModuleName() {
        if (UITestRunner.getIdeaVersionInt() >= 20221) {
            return ((JTextFieldFixture)this.find(JTextFieldFixture.class, Locators.byXpath((String)"//div[@accessiblename='Module name:' and @accessiblename.key='label.project.wizard.new.project.module.name' and @class='JBTextField']"))).getText();
        }
        return this.textField("Module name:", true).getText();
    }

    public void setModuleName(String moduleName) {
        if (UITestRunner.getIdeaVersionInt() >= 20221) {
            ((JTextFieldFixture)this.find(JTextFieldFixture.class, Locators.byXpath((String)"//div[@accessiblename='Module name:' and @accessiblename.key='label.project.wizard.new.project.module.name' and @class='JBTextField']"))).setText(moduleName);
        } else {
            this.textField("Module name:", true).setText(moduleName);
        }
    }

    public String getContentRoot() {
        if (UITestRunner.getIdeaVersionInt() >= 20221) {
            return ((JTextFieldFixture)this.find(JTextFieldFixture.class, Locators.byXpath((String)"//div[@accessiblename='Content root:' and @accessiblename.key='label.project.wizard.new.project.content.root' and @class='ExtendableTextField']"))).getText();
        }
        return this.textField("Content root:", true).getText();
    }

    public void setContentRoot(String contentRoot) {
        if (UITestRunner.getIdeaVersionInt() >= 20221) {
            ((JTextFieldFixture)this.find(JTextFieldFixture.class, Locators.byXpath((String)"//div[@accessiblename='Content root:' and @accessiblename.key='label.project.wizard.new.project.content.root' and @class='ExtendableTextField']"))).setText(contentRoot);
        } else {
            this.textField("Content root:", true).setText(contentRoot);
        }
    }

    public String getModuleFileLocation() {
        if (UITestRunner.getIdeaVersionInt() >= 20221) {
            return ((JTextFieldFixture)this.find(JTextFieldFixture.class, Locators.byXpath((String)"//div[@accessiblename='Module file location:' and @accessiblename.key='label.project.wizard.new.project.module.file.location' and @class='ExtendableTextField']"))).getText();
        }
        return this.textField("Module file location:", true).getText();
    }

    public void setModuleFileLocation(String moduleFileLocation) {
        if (UITestRunner.getIdeaVersionInt() >= 20221) {
            ((JTextFieldFixture)this.find(JTextFieldFixture.class, Locators.byXpath((String)"//div[@accessiblename='Module file location:' and @accessiblename.key='label.project.wizard.new.project.module.file.location' and @class='ExtendableTextField']"))).setText(moduleFileLocation);
        } else {
            this.textField("Module file location:", true).setText(moduleFileLocation);
        }
    }

    public AbstractNewProjectFinalPage.ProjectFormatType getProjectFormat() {
        ComboBoxFixture projectFormatComboBox = this.comboBox(Locators.byXpath((String)"//div[@class='JComboBox']"), Duration.ofSeconds(10L));
        if (projectFormatComboBox.selectedText().contains(AbstractNewProjectFinalPage.ProjectFormatType.IDEA_DIRECTORY_BASED.toString())) {
            return AbstractNewProjectFinalPage.ProjectFormatType.IDEA_DIRECTORY_BASED;
        }
        if (projectFormatComboBox.selectedText().contains(AbstractNewProjectFinalPage.ProjectFormatType.IPR_FILE_BASED.toString())) {
            return AbstractNewProjectFinalPage.ProjectFormatType.IPR_FILE_BASED;
        }
        throw new UITestException("Currently selected project format is not supported.");
    }

    public void setProjectFormat(AbstractNewProjectFinalPage.ProjectFormatType projectFormatType) {
        ComboBoxFixture projectFormatComboBox = this.comboBox(Locators.byXpath((String)"//div[@class='JComboBox']"), Duration.ofSeconds(10L));
        projectFormatComboBox.selectItemContains(projectFormatType.toString());
    }

    private boolean isMoreSettingOpened() {
        return this.findAll(ContainerFixture.class, Locators.byXpath((String)"//div[@class='TitledSeparator']/../../*")).size() == 2;
    }
}

