/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonuitest.fixtures.mainidewindow.toolwindowspane;

import com.intellij.remoterobot.RemoteRobot;
import com.intellij.remoterobot.data.RemoteComponent;
import com.intellij.remoterobot.fixtures.CommonContainerFixture;
import com.intellij.remoterobot.fixtures.Fixture;
import com.intellij.remoterobot.fixtures.JButtonFixture;
import com.intellij.remoterobot.search.locators.Locators;
import com.intellij.remoterobot.utils.RepeatUtilsKt;
import com.intellij.remoterobot.utils.WaitForConditionTimeoutException;
import com.redhat.devtools.intellij.commonuitest.UITestRunner;
import com.redhat.devtools.intellij.commonuitest.fixtures.mainidewindow.toolwindowspane.ProjectExplorer;
import com.redhat.devtools.intellij.commonuitest.fixtures.mainidewindow.toolwindowspane.ToolWindowPane;
import com.redhat.devtools.intellij.commonuitest.fixtures.mainidewindow.toolwindowspane.ToolWindowsPane;
import com.redhat.devtools.intellij.commonuitest.fixtures.mainidewindow.toolwindowspane.buildtoolpane.GradleBuildToolPane;
import com.redhat.devtools.intellij.commonuitest.fixtures.mainidewindow.toolwindowspane.buildtoolpane.MavenBuildToolPane;
import com.redhat.devtools.intellij.commonuitest.utils.constants.XPathDefinitions;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractToolWinPane
extends CommonContainerFixture {
    private final RemoteRobot remoteRobot;

    protected AbstractToolWinPane(@NotNull RemoteRobot remoteRobot, @NotNull RemoteComponent remoteComponent) {
        super(remoteRobot, remoteComponent);
        this.remoteRobot = remoteRobot;
    }

    public ProjectExplorer openProjectExplorer() {
        return this.togglePane("Project", ProjectExplorer.class, true);
    }

    public void closeProjectExplorer() {
        this.togglePane("Project", ProjectExplorer.class, false);
    }

    public MavenBuildToolPane openMavenBuildToolPane() {
        return this.togglePane("Maven", MavenBuildToolPane.class, true);
    }

    public void closeMavenBuildToolPane() {
        this.togglePane("Maven", MavenBuildToolPane.class, false);
    }

    public GradleBuildToolPane openGradleBuildToolPane() {
        return this.togglePane("Gradle", GradleBuildToolPane.class, true);
    }

    public void closeGradleBuildToolPane() {
        this.togglePane("Gradle", GradleBuildToolPane.class, false);
    }

    public JButtonFixture stripeButton(String label, boolean isPaneOpened) {
        if (isPaneOpened) {
            if (label.equals("Maven") || label.equals("Gradle")) {
                if (UITestRunner.getIdeaVersionInt() >= 20232) {
                    return this.button(Locators.byXpath((String)XPathDefinitions.toolWindowButton(label)), Duration.ofSeconds(2L));
                }
                return this.button(Locators.byXpath((String)XPathDefinitions.toolWindowSvg(label)), Duration.ofSeconds(2L));
            }
            if (label.equals("Project")) {
                return this.button(Locators.byXpath((String)"//div[@tooltiptext='Project']"), Duration.ofSeconds(2L));
            }
        }
        return this.button(Locators.byXpath((String)XPathDefinitions.label(label)), Duration.ofSeconds(2L));
    }

    protected <T extends Fixture> T togglePane(String label, Class<T> fixtureClass, boolean openPane) {
        if (!this.isPaneOpened(fixtureClass) && openPane) {
            this.clickOnStripeButton(label, false);
            return (T)this.find(fixtureClass, Duration.ofSeconds(10L));
        }
        if (this.isPaneOpened(fixtureClass) && !openPane) {
            this.clickOnStripeButton(label, true);
        }
        return null;
    }

    private boolean isPaneOpened(Class<? extends Fixture> fixtureClass) {
        AbstractToolWinPane toolWinPane = UITestRunner.getIdeaVersionInt() >= 20221 ? (AbstractToolWinPane)this.remoteRobot.find(ToolWindowPane.class, Duration.ofSeconds(10L)) : (AbstractToolWinPane)this.remoteRobot.find(ToolWindowsPane.class, Duration.ofSeconds(10L));
        try {
            toolWinPane.find(fixtureClass, Duration.ofSeconds(10L));
            return true;
        }
        catch (WaitForConditionTimeoutException e) {
            return false;
        }
    }

    private void clickOnStripeButton(String label, boolean isPaneOpened) {
        RepeatUtilsKt.waitFor((Duration)Duration.ofSeconds(30L), (Duration)Duration.ofSeconds(2L), (String)("The '" + label + "' stripe button is not available."), () -> this.isStripeButtonAvailable(label, isPaneOpened));
        if (UITestRunner.getIdeaVersionInt() >= 20221) {
            ((ToolWindowPane)this.remoteRobot.find(ToolWindowPane.class, Duration.ofSeconds(10L))).stripeButton(label, isPaneOpened).click();
        } else {
            ((ToolWindowsPane)this.remoteRobot.find(ToolWindowsPane.class, Duration.ofSeconds(10L))).stripeButton(label, isPaneOpened).click();
        }
    }

    private boolean isStripeButtonAvailable(String label, boolean isPaneOpened) {
        try {
            if (UITestRunner.getIdeaVersionInt() >= 20221) {
                ((ToolWindowPane)this.remoteRobot.find(ToolWindowPane.class, Duration.ofSeconds(2L))).stripeButton(label, isPaneOpened);
            } else {
                ((ToolWindowsPane)this.remoteRobot.find(ToolWindowsPane.class, Duration.ofSeconds(2L))).stripeButton(label, isPaneOpened);
            }
        }
        catch (WaitForConditionTimeoutException e) {
            return false;
        }
        return true;
    }
}

