/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonuitest.fixtures.mainidewindow.toolwindowspane;

import com.intellij.remoterobot.RemoteRobot;
import com.intellij.remoterobot.data.RemoteComponent;
import com.intellij.remoterobot.fixtures.CommonContainerFixture;
import com.intellij.remoterobot.fixtures.DefaultXpath;
import com.intellij.remoterobot.fixtures.FixtureName;
import com.intellij.remoterobot.fixtures.JTreeFixture;
import com.intellij.remoterobot.fixtures.TextEditorFixture;
import com.intellij.remoterobot.search.locators.Locators;
import com.intellij.remoterobot.utils.RepeatUtilsKt;
import com.redhat.devtools.intellij.commonuitest.utils.texttranformation.TextUtils;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;

@DefaultXpath(by="ToolWindowsPane type", xpath="//div[@class='BuildView']")
@FixtureName(name="Tool Windows Pane")
public class BuildView
extends CommonContainerFixture {
    private String lastBuildStatusTreeText;

    public BuildView(@NotNull RemoteRobot remoteRobot, @NotNull RemoteComponent remoteComponent) {
        super(remoteRobot, remoteComponent);
    }

    public void waitUntilBuildHasFinished() {
        RepeatUtilsKt.waitFor((Duration)Duration.ofSeconds(300L), (Duration)Duration.ofSeconds(3L), (String)"The build did not finish in 5 minutes.", this::didBuildStatusTreeTextStopChanging);
    }

    public boolean isBuildSuccessful() {
        String runConsoleOutput = TextUtils.listOfRemoteTextToString(this.buildConsole().findAllText());
        return runConsoleOutput.contains("BUILD SUCCESS") || runConsoleOutput.contains("exit code 0");
    }

    public JTreeFixture buildStatusTree() {
        return (JTreeFixture)this.find(JTreeFixture.class, Locators.byXpath((String)"//div[@class='Tree']"));
    }

    public TextEditorFixture buildConsole() {
        return this.textEditor(Locators.byXpath((String)"//div[@accessiblename='Editor']"), Duration.ofSeconds(2L));
    }

    private boolean didBuildStatusTreeTextStopChanging() {
        String updatedBuildStatusTreeText = this.getBuildStatusTreeText();
        if (this.lastBuildStatusTreeText != null && this.lastBuildStatusTreeText.equals(updatedBuildStatusTreeText)) {
            this.lastBuildStatusTreeText = null;
            return true;
        }
        this.lastBuildStatusTreeText = updatedBuildStatusTreeText;
        return false;
    }

    private String getBuildStatusTreeText() {
        return TextUtils.listOfRemoteTextToString(this.buildStatusTree().findAllText());
    }
}

