/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.project.pages;

import com.intellij.remoterobot.RemoteRobot;
import com.intellij.remoterobot.data.RemoteComponent;
import com.intellij.remoterobot.fixtures.ComboBoxFixture;
import com.intellij.remoterobot.fixtures.CommonContainerFixture;
import com.intellij.remoterobot.fixtures.DefaultXpath;
import com.intellij.remoterobot.fixtures.FixtureName;
import com.intellij.remoterobot.fixtures.HeavyWeightWindowFixture;
import com.intellij.remoterobot.fixtures.JLabelFixture;
import com.intellij.remoterobot.fixtures.JListFixture;
import com.intellij.remoterobot.fixtures.JPopupMenuFixture;
import com.intellij.remoterobot.fixtures.JTextFieldFixture;
import com.intellij.remoterobot.fixtures.dataExtractor.RemoteText;
import com.intellij.remoterobot.search.locators.Locators;
import com.intellij.remoterobot.stepsProcessing.StepWorkerKt;
import com.intellij.remoterobot.utils.RepeatUtilsKt;
import com.intellij.remoterobot.utils.WaitForConditionTimeoutException;
import com.redhat.devtools.intellij.commonuitest.UITestRunner;
import com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.project.pages.AbstractNewProjectFinalPage;
import com.redhat.devtools.intellij.commonuitest.utils.texttranformation.TextUtils;
import java.time.Duration;
import java.util.List;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;

@DefaultXpath(by="MyDialog type", xpath="//div[@class='DialogRootPane']")
@FixtureName(name="New Project Dialog")
public class NewProjectFirstPage
extends AbstractNewProjectFinalPage {
    private final RemoteRobot remoteRobot;
    private int projectSdkItemsCount = -1;
    private final int ideaVersion;

    public NewProjectFirstPage(@NotNull RemoteRobot remoteRobot, @NotNull RemoteComponent remoteComponent) {
        super(remoteRobot, remoteComponent);
        this.remoteRobot = remoteRobot;
        this.ideaVersion = UITestRunner.getIdeaVersion().toInt();
    }

    public void selectNewProjectType(String projectType) {
        ((JListFixture)this.jLists(JListFixture.Companion.byType()).get(0)).findText(projectType).click();
    }

    @Override
    public void setProjectName(String projectName) {
        ((JTextFieldFixture)this.find(JTextFieldFixture.class, Locators.byXpath((String)"//div[@class='JBTextField']"))).setText(projectName);
    }

    public JTextFieldFixture getProjectNameTextField() {
        return (JTextFieldFixture)this.find(JTextFieldFixture.class, Locators.byXpath((String)"//div[@class='JBTextField']"), Duration.ofSeconds(10L));
    }

    public void setLanguage(String language) {
        if (this.ideaVersion >= 20241) {
            JListFixture jListFixture = (JListFixture)this.remoteRobot.find(JListFixture.class, Locators.byXpath((String)"//div[@class='JBList']"));
            jListFixture.clickItem(language, false);
        } else {
            ((JLabelFixture)this.findAll(JLabelFixture.class, Locators.byXpath((String)"//div[@class='SegmentedButtonComponent'][.//div[contains(@action.key, 'language.groovy')]]")).get(0)).findText(language).click();
        }
    }

    public void setBuildSystem(String buildSystem) {
        if (this.ideaVersion >= 20241) {
            ((JLabelFixture)this.find(JLabelFixture.class, Locators.byXpath((String)"//div[@accessiblename='Build system:' and @class='SegmentedButtonComponent']"))).findText(buildSystem).click();
        } else {
            ((JLabelFixture)this.find(JLabelFixture.class, Locators.byXpath((String)"//div[@class='SegmentedButtonComponent'][.//div[@action.key='buildsystem.type.intellij']]"))).findText(buildSystem).click();
        }
    }

    public ComboBoxFixture getProjectJdkComboBox() {
        if (this.ideaVersion >= 20241) {
            return this.comboBox(Locators.byXpath((String)"//div[@class='ProjectWizardJdkComboBox']"), Duration.ofSeconds(10L));
        }
        return this.comboBox(Locators.byXpath((String)"//div[@class='JdkComboBox']"), Duration.ofSeconds(10L));
    }

    public void setProjectSdkIfAvailable(String targetSdkName) {
        StepWorkerKt.step((String)("Select the '" + targetSdkName + "' as new project SDK"), () -> {
            ComboBoxFixture projectJdkComboBox = this.getProjectJdkComboBox();
            String currentlySelectedProjectSdk = TextUtils.listOfRemoteTextToString(projectJdkComboBox.findAllText());
            if (currentlySelectedProjectSdk.contains(targetSdkName)) {
                return;
            }
            if (UITestRunner.getIdeaVersionInt() >= 20221) {
                projectJdkComboBox.click();
                boolean popupOpenedPermanently = false;
                try {
                    RepeatUtilsKt.waitFor((Duration)Duration.ofSeconds(10L), (Duration)Duration.ofMillis(250L), (String)"HeavyWeightWindow still visible.", this::noHeavyWeightWindowVisible);
                }
                catch (WaitForConditionTimeoutException e) {
                    popupOpenedPermanently = true;
                }
                if (!popupOpenedPermanently) {
                    projectJdkComboBox.click();
                }
            }
            CommonContainerFixture parentFixture = (CommonContainerFixture)RepeatUtilsKt.waitFor((Duration)Duration.ofSeconds(20L), (Duration)Duration.ofSeconds(2L), (String)"Wait for the 'Project SDK' list to finish loading all items.", (String)"The project JDK list did not load all items in 20 seconds.", this::didProjectSdkListLoadAllItems);
            JPopupMenuFixture projectSdkList = (JPopupMenuFixture)parentFixture.jPopupMenus(Locators.byXpath((String)"//div[@class='HeavyWeightWindow']")).get(0);
            List sdkItems = projectSdkList.findAllText();
            for (RemoteText sdkItem : sdkItems) {
                if (!sdkItem.getText().contains(targetSdkName)) continue;
                try {
                    sdkItem.click();
                }
                catch (Exception e) {
                    break;
                }
            }
        });
    }

    private Pair<Boolean, CommonContainerFixture> didProjectSdkListLoadAllItems() {
        return (Pair)StepWorkerKt.step((String)"Test whether the 'Project SDK' list has loaded all items", () -> {
            CommonContainerFixture parentFixture = (CommonContainerFixture)this.remoteRobot.find(CommonContainerFixture.class, Locators.byXpath((String)"//div[@class='MyDialog']"));
            JPopupMenuFixture projectSdkList = (JPopupMenuFixture)parentFixture.jPopupMenus(Locators.byXpath((String)"//div[@class='HeavyWeightWindow']")).get(0);
            List sdkItems = projectSdkList.findAllText();
            int currentSdkItemsCount = sdkItems.size();
            if (this.projectSdkItemsCount == -1 || this.projectSdkItemsCount != currentSdkItemsCount) {
                this.projectSdkItemsCount = currentSdkItemsCount;
                return new Pair((Object)false, (Object)parentFixture);
            }
            return new Pair((Object)true, (Object)parentFixture);
        });
    }

    private boolean noHeavyWeightWindowVisible() {
        return this.remoteRobot.findAll(HeavyWeightWindowFixture.class).isEmpty();
    }
}

