/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonuitest.fixtures.mainidewindow.menubar;

import com.intellij.remoterobot.RemoteRobot;
import com.intellij.remoterobot.fixtures.CommonContainerFixture;
import com.intellij.remoterobot.fixtures.JButtonFixture;
import com.intellij.remoterobot.fixtures.JPopupMenuFixture;
import com.intellij.remoterobot.search.locators.Locators;
import com.intellij.remoterobot.utils.RepeatUtilsKt;
import com.redhat.devtools.intellij.commonuitest.UITestRunner;
import com.redhat.devtools.intellij.commonuitest.utils.constants.XPathDefinitions;
import com.redhat.devtools.intellij.commonuitest.utils.runner.IntelliJVersion;
import java.time.Duration;
import java.util.List;

public class MenuBar {
    private final RemoteRobot remoteRobot;
    private final IntelliJVersion ideaVersion;

    public MenuBar(RemoteRobot remoteRobot) {
        this.remoteRobot = remoteRobot;
        this.ideaVersion = UITestRunner.getIdeaVersion();
    }

    public void navigateTo(String ... path) {
        if (path.length == 0) {
            return;
        }
        JButtonFixture mainMenuFirstItem = this.mainMenuItem(path[0]);
        if (mainMenuFirstItem != null) {
            mainMenuFirstItem.click();
            RepeatUtilsKt.waitFor((Duration)Duration.ofSeconds(5L), (Duration)Duration.ofSeconds(1L), (String)"JPopupMenu to appear", () -> !this.remoteRobot.findAll(JPopupMenuFixture.class, JPopupMenuFixture.Companion.byType()).isEmpty());
        }
        if (path.length == 1) {
            return;
        }
        for (int i = 1; i < path.length - 1; ++i) {
            List allContextMenus = this.remoteRobot.findAll(JPopupMenuFixture.class, JPopupMenuFixture.Companion.byType());
            JPopupMenuFixture lastContextMenu = (JPopupMenuFixture)allContextMenus.get(allContextMenus.size() - 1);
            lastContextMenu.findText(path[i]).moveMouse();
        }
        List allContextMenus = this.remoteRobot.findAll(JPopupMenuFixture.class, JPopupMenuFixture.Companion.byType());
        JPopupMenuFixture lastContextMenu = (JPopupMenuFixture)allContextMenus.get(allContextMenus.size() - 1);
        lastContextMenu.findText(path[path.length - 1]).click();
    }

    private JButtonFixture mainMenuItem(String label) {
        if (this.remoteRobot.isMac()) {
            return null;
        }
        CommonContainerFixture cf = this.remoteRobot.isLinux() ? (CommonContainerFixture)this.remoteRobot.find(CommonContainerFixture.class, Locators.byXpath((String)"//div[@class='LinuxIdeMenuBar']"), Duration.ofSeconds(10L)) : (this.remoteRobot.isWin() && this.ideaVersion.toInt() >= 20241 ? (CommonContainerFixture)this.remoteRobot.find(CommonContainerFixture.class, Locators.byXpath((String)"//div[@class='IdeJMenuBar']"), Duration.ofSeconds(10L)) : (this.remoteRobot.isWin() && this.ideaVersion.toInt() >= 20222 ? (CommonContainerFixture)this.remoteRobot.find(CommonContainerFixture.class, Locators.byXpath((String)"//div[@class='IdeMenuBar']"), Duration.ofSeconds(10L)) : (this.remoteRobot.isWin() && this.ideaVersion.toInt() >= 20203 ? (CommonContainerFixture)this.remoteRobot.find(CommonContainerFixture.class, Locators.byXpath((String)"//div[@class='MenuFrameHeader']"), Duration.ofSeconds(10L)) : (CommonContainerFixture)this.remoteRobot.find(CommonContainerFixture.class, Locators.byXpath((String)"//div[@class='CustomHeaderMenuBar']"), Duration.ofSeconds(10L)))));
        return cf.button(Locators.byXpath((String)XPathDefinitions.label(label)), Duration.ofSeconds(10L));
    }
}

