/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonuitest.fixtures.mainidewindow.toolwindowspane;

import com.intellij.remoterobot.RemoteRobot;
import com.intellij.remoterobot.data.RemoteComponent;
import com.intellij.remoterobot.fixtures.CommonContainerFixture;
import com.intellij.remoterobot.fixtures.DefaultXpath;
import com.intellij.remoterobot.fixtures.FixtureName;
import com.intellij.remoterobot.fixtures.JPopupMenuFixture;
import com.intellij.remoterobot.fixtures.JTreeFixture;
import com.intellij.remoterobot.search.locators.Locators;
import com.intellij.remoterobot.utils.WaitForConditionTimeoutException;
import com.redhat.devtools.intellij.commonuitest.UITestRunner;
import com.redhat.devtools.intellij.commonuitest.exceptions.UITestException;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;

@DefaultXpath(by="ToolWindowsPane type", xpath="//div[@accessiblename='Project Tool Window']")
@FixtureName(name="Tool Windows Pane")
public class ProjectExplorer
extends CommonContainerFixture {
    private final RemoteRobot remoteRobot;

    public ProjectExplorer(@NotNull RemoteRobot remoteRobot, @NotNull RemoteComponent remoteComponent) {
        super(remoteRobot, remoteComponent);
        this.remoteRobot = remoteRobot;
    }

    public boolean isItemPresent(String ... path) {
        this.projectViewTree().expand(path);
        path[0] = this.projectViewTree().getValueAtRow(0);
        return this.projectViewTree().isPathExists(path, true);
    }

    public void openFile(String ... path) {
        this.projectViewTree().expand(path);
        path[0] = this.projectViewTree().getValueAtRow(0);
        this.projectViewTree().doubleClickPath(path, true);
    }

    public JPopupMenuFixture openContextMenuOn(String ... path) {
        this.projectViewTree().expand(path);
        this.projectViewTree().rightClickPath(path, true);
        try {
            return (JPopupMenuFixture)this.remoteRobot.find(JPopupMenuFixture.class, Locators.byXpath((String)"//div[@class='HeavyWeightWindow']"), Duration.ofSeconds(10L));
        }
        catch (WaitForConditionTimeoutException e) {
            throw new UITestException("The context menu for a file in Project Explorer has not been found.");
        }
    }

    public JPopupMenuFixture openViewsPopup() {
        this.projectViewTree().moveMouse();
        this.actionButton(Locators.byXpath((String)"//div[@class='ContentComboLabel']"), Duration.ofSeconds(5L)).click();
        try {
            return (JPopupMenuFixture)this.remoteRobot.find(JPopupMenuFixture.class, Locators.byXpath((String)"//div[@class='HeavyWeightWindow']"), Duration.ofSeconds(10L));
        }
        catch (WaitForConditionTimeoutException e) {
            throw new UITestException(e.getMessage());
        }
    }

    public void selectOpenedFile() {
        this.projectViewTree().moveMouse();
        this.actionButton(Locators.byXpath((String)"//div[@myicon='locate.svg']"), Duration.ofSeconds(5L)).click();
    }

    public void expandAll() {
        this.projectViewTree().moveMouse();
        if (UITestRunner.getIdeaVersionInt() >= 20242) {
            this.actionButton(Locators.byXpath((String)"//div[@myicon='expandAll.svg']"), Duration.ofSeconds(5L)).click();
        } else {
            this.actionButton(Locators.byXpath((String)"//div[contains(@myvisibleactions, 'View),')]//div[@myicon='expandall.svg']"), Duration.ofSeconds(5L)).click();
        }
    }

    public void collapseAll() {
        this.projectViewTree().moveMouse();
        if (UITestRunner.getIdeaVersionInt() >= 20242) {
            this.actionButton(Locators.byXpath((String)"//div[@myicon='collapseAll.svg']"), Duration.ofSeconds(5L)).click();
        } else {
            this.actionButton(Locators.byXpath((String)"//div[contains(@myvisibleactions, 'View),')]//div[@myicon='collapseall.svg']"), Duration.ofSeconds(5L)).click();
        }
    }

    public JPopupMenuFixture openSettingsPopup() {
        this.projectViewTree().moveMouse();
        if (UITestRunner.getIdeaVersionInt() >= 20242) {
            this.actionButton(Locators.byXpath((String)"//div[@myicon='moreVertical.svg']"), Duration.ofSeconds(5L)).click();
        } else {
            this.actionButton(Locators.byXpath((String)"//div[contains(@myvisibleactions, 'View),')]//div[@myicon='gearPlain.svg']"), Duration.ofSeconds(5L)).click();
        }
        try {
            return (JPopupMenuFixture)this.remoteRobot.find(JPopupMenuFixture.class, Locators.byXpath((String)"//div[@class='HeavyWeightWindow']"), Duration.ofSeconds(10L));
        }
        catch (WaitForConditionTimeoutException e) {
            throw new UITestException(e.getMessage());
        }
    }

    public void hide() {
        this.projectViewTree().moveMouse();
        this.actionButton(Locators.byXpath((String)"//div[contains(@myvisibleactions, 'View),')]//div[@tooltiptext='Hide']"), Duration.ofSeconds(5L)).click();
    }

    public JTreeFixture projectViewTree() {
        return (JTreeFixture)this.find(JTreeFixture.class, JTreeFixture.Companion.byType(), Duration.ofSeconds(10L));
    }
}

