/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonuitest.fixtures.mainidewindow.toolwindowspane.buildtoolpane;

import com.intellij.remoterobot.RemoteRobot;
import com.intellij.remoterobot.data.RemoteComponent;
import com.intellij.remoterobot.fixtures.CommonContainerFixture;
import com.intellij.remoterobot.fixtures.DefaultXpath;
import com.intellij.remoterobot.fixtures.FixtureName;
import com.intellij.remoterobot.fixtures.JTreeFixture;
import com.intellij.remoterobot.fixtures.dataExtractor.RemoteText;
import com.intellij.remoterobot.search.locators.Locators;
import com.intellij.remoterobot.utils.RepeatUtilsKt;
import com.redhat.devtools.intellij.commonuitest.UITestRunner;
import com.redhat.devtools.intellij.commonuitest.fixtures.mainidewindow.idestatusbar.IdeStatusBar;
import com.redhat.devtools.intellij.commonuitest.fixtures.mainidewindow.toolwindowspane.BuildView;
import com.redhat.devtools.intellij.commonuitest.fixtures.mainidewindow.toolwindowspane.ToolWindowPane;
import com.redhat.devtools.intellij.commonuitest.fixtures.mainidewindow.toolwindowspane.ToolWindowsPane;
import com.redhat.devtools.intellij.commonuitest.utils.texttranformation.TextUtils;
import java.time.Duration;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

@DefaultXpath(by="ToolWindowsPane type", xpath="//div[@accessiblename='Gradle Tool Window']")
@FixtureName(name="Tool Windows Pane")
public class GradleBuildToolPane
extends CommonContainerFixture {
    private final RemoteRobot remoteRobot;

    public GradleBuildToolPane(@NotNull RemoteRobot remoteRobot, @NotNull RemoteComponent remoteComponent) {
        super(remoteRobot, remoteComponent);
        this.remoteRobot = remoteRobot;
    }

    public void reloadAllGradleProjects() {
        this.actionButton(Locators.byXpath((String)"//div[@myicon='refresh.svg']"), Duration.ofSeconds(2L)).click();
        ((IdeStatusBar)this.remoteRobot.find(IdeStatusBar.class, Duration.ofSeconds(10L))).waitUntilAllBgTasksFinish();
    }

    public void expandAll() {
        if (UITestRunner.getIdeaVersionInt() >= 20242) {
            this.actionButton(Locators.byXpath((String)"//div[@myicon='expandAll.svg']"), Duration.ofSeconds(2L)).click();
        } else {
            this.actionButton(Locators.byXpath((String)"//div[contains(@myvisibleactions, 'IDE')]//div[@myicon='expandall.svg']"), Duration.ofSeconds(2L)).click();
        }
    }

    public void collapseAll() {
        if (UITestRunner.getIdeaVersionInt() >= 20242) {
            this.actionButton(Locators.byXpath((String)"//div[@myicon='collapseAll.svg']"), Duration.ofSeconds(2L)).click();
        } else {
            this.actionButton(Locators.byXpath((String)"//div[contains(@myvisibleactions, 'IDE')]//div[@myicon='collapseall.svg']"), Duration.ofSeconds(2L)).click();
        }
    }

    public void buildProject() {
        RepeatUtilsKt.waitFor((Duration)Duration.ofSeconds(30L), (Duration)Duration.ofSeconds(2L), (String)"The Gradle tasks tree did not appear in 30 seconds.", this::isGradleTreeVisible);
        if (this.remoteRobot.isMac()) {
            this.expandAll();
        } else {
            this.gradleTaskTree().expandAll();
        }
        ((RemoteText)this.gradleTaskTree().findAllText("build").get(1)).doubleClick();
        if (UITestRunner.getIdeaVersionInt() >= 20221) {
            ((BuildView)((ToolWindowPane)this.remoteRobot.find(ToolWindowPane.class)).find(BuildView.class)).waitUntilBuildHasFinished();
        } else {
            ((BuildView)((ToolWindowsPane)this.remoteRobot.find(ToolWindowsPane.class)).find(BuildView.class)).waitUntilBuildHasFinished();
        }
        ((IdeStatusBar)this.remoteRobot.find(IdeStatusBar.class, Duration.ofSeconds(10L))).waitUntilAllBgTasksFinish();
    }

    public JTreeFixture gradleTaskTree() {
        return (JTreeFixture)this.find(JTreeFixture.class, JTreeFixture.Companion.byType(), Duration.ofSeconds(10L));
    }

    private boolean isGradleTreeVisible() {
        String treeContent = TextUtils.listOfRemoteTextToString(this.gradleTaskTree().findAllText());
        return !treeContent.toLowerCase(Locale.ROOT).contains("nothing") && !treeContent.equals("");
    }
}

