/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonuitest.utils.project;

import com.intellij.remoterobot.RemoteRobot;
import com.intellij.remoterobot.fixtures.ComponentFixture;
import com.intellij.remoterobot.search.locators.Locators;
import com.intellij.remoterobot.utils.RepeatUtilsKt;
import com.redhat.devtools.intellij.commonuitest.UITestRunner;
import com.redhat.devtools.intellij.commonuitest.exceptions.UITestException;
import com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.FlatWelcomeFrame;
import com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.information.CodeWithMeDialog;
import com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.project.NewProjectDialogWizard;
import com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.project.pages.AbstractNewProjectFinalPage;
import com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.project.pages.JavaNewProjectFinalPage;
import com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.project.pages.MavenGradleNewProjectFinalPage;
import com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.project.pages.NewProjectFirstPage;
import com.redhat.devtools.intellij.commonuitest.fixtures.mainidewindow.MainIdeWindow;
import com.redhat.devtools.intellij.commonuitest.fixtures.mainidewindow.idestatusbar.IdeStatusBar;
import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

public class CreateCloseUtils {
    public static final String PROJECT_LOCATION = Optional.ofNullable(System.getProperty("testProjectLocation")).filter(s -> !s.isEmpty()).orElseGet(() -> System.getProperty("user.home") + File.separator + "IdeaProjects" + File.separator + "intellij-ui-test-projects");

    public static void createNewProject(RemoteRobot remoteRobot, String projectName, NewProjectType newProjectType) {
        NewProjectDialogWizard newProjectDialogWizard = CreateCloseUtils.openNewProjectDialogFromWelcomeDialog(remoteRobot);
        NewProjectFirstPage newProjectFirstPage = (NewProjectFirstPage)newProjectDialogWizard.find(NewProjectFirstPage.class, Duration.ofSeconds(10L));
        if (UITestRunner.getIdeaVersionInt() >= 20221) {
            newProjectFirstPage.selectNewProjectType("New Project");
            newProjectFirstPage.setLanguage("Java");
            switch (newProjectType) {
                case PLAIN_JAVA: {
                    newProjectFirstPage.setBuildSystem("IntelliJ");
                    break;
                }
                case MAVEN: 
                case GRADLE: {
                    newProjectFirstPage.setBuildSystem(newProjectType.toString());
                }
            }
        } else {
            newProjectFirstPage.selectNewProjectType(newProjectType.toString());
        }
        newProjectFirstPage.setProjectSdkIfAvailable("17");
        if (UITestRunner.getIdeaVersionInt() >= 20221) {
            newProjectFirstPage.getProjectNameTextField().click();
            newProjectFirstPage.setProjectName(projectName);
            newProjectFirstPage.setProjectLocation(PROJECT_LOCATION);
        } else {
            newProjectDialogWizard.next();
            if (newProjectType.equals((Object)NewProjectType.PLAIN_JAVA)) {
                newProjectDialogWizard.next();
            }
            AbstractNewProjectFinalPage finalPage = CreateCloseUtils.getFinalPage(newProjectDialogWizard, newProjectType);
            finalPage.setProjectName(projectName);
        }
        newProjectDialogWizard.finish();
        CreateCloseUtils.waitAfterOpeningProject(remoteRobot);
    }

    public static void createEmptyProject(RemoteRobot remoteRobot, String projectName) {
        NewProjectDialogWizard newProjectDialogWizard = CreateCloseUtils.openNewProjectDialogFromWelcomeDialog(remoteRobot);
        NewProjectFirstPage newProjectFirstPage = (NewProjectFirstPage)newProjectDialogWizard.find(NewProjectFirstPage.class, Duration.ofSeconds(10L));
        newProjectFirstPage.selectNewProjectType(NewProjectType.EMPTY_PROJECT.toString());
        CreateCloseUtils.ensureEmptyProjectPageIsOpened(newProjectFirstPage, remoteRobot);
        newProjectFirstPage.setProjectName(projectName);
        newProjectFirstPage.setProjectLocation(PROJECT_LOCATION);
        newProjectDialogWizard.finish();
        CreateCloseUtils.waitAfterOpeningProject(remoteRobot);
    }

    public static void waitAfterOpeningProject(RemoteRobot remoteRobot) {
        IdeStatusBar ideStatusBar = (IdeStatusBar)remoteRobot.find(IdeStatusBar.class, Duration.ofSeconds(10L));
        ideStatusBar.waitUntilProjectImportIsComplete();
        MainIdeWindow mainIdeWindow = (MainIdeWindow)remoteRobot.find(MainIdeWindow.class, Duration.ofSeconds(5L));
        mainIdeWindow.maximizeIdeWindow();
        ideStatusBar.waitUntilAllBgTasksFinish(500);
        CodeWithMeDialog.closeCodeWithMePopupIfItAppears(remoteRobot);
    }

    public static NewProjectDialogWizard openNewProjectDialogFromWelcomeDialog(RemoteRobot remoteRobot) {
        FlatWelcomeFrame flatWelcomeFrame = (FlatWelcomeFrame)remoteRobot.find(FlatWelcomeFrame.class, Duration.ofSeconds(10L));
        flatWelcomeFrame.switchToProjectsPage();
        flatWelcomeFrame.createNewProject();
        return (NewProjectDialogWizard)remoteRobot.find(NewProjectDialogWizard.class, Duration.ofSeconds(10L));
    }

    public static void closeProject(RemoteRobot remoteRobot) {
        MainIdeWindow mainIdeWindow = (MainIdeWindow)remoteRobot.find(MainIdeWindow.class, Duration.ofSeconds(10L));
        mainIdeWindow.closeProject();
        remoteRobot.find(FlatWelcomeFrame.class, Duration.ofSeconds(10L));
    }

    public static void openProjectFromWelcomeDialog(RemoteRobot remoteRobot, String projectName) {
        FlatWelcomeFrame flatWelcomeFrame = (FlatWelcomeFrame)remoteRobot.find(FlatWelcomeFrame.class, Duration.ofSeconds(10L));
        flatWelcomeFrame.openProject(projectName);
        CreateCloseUtils.waitAfterOpeningProject(remoteRobot);
    }

    public static AbstractNewProjectFinalPage getFinalPage(NewProjectDialogWizard newProjectDialogWizard, NewProjectType newProjectType) {
        switch (newProjectType) {
            case PLAIN_JAVA: {
                return (AbstractNewProjectFinalPage)newProjectDialogWizard.find(JavaNewProjectFinalPage.class, Duration.ofSeconds(10L));
            }
            case MAVEN: 
            case GRADLE: {
                return (AbstractNewProjectFinalPage)newProjectDialogWizard.find(MavenGradleNewProjectFinalPage.class, Duration.ofSeconds(10L));
            }
        }
        throw new UITestException("Unsupported project type.");
    }

    private static void ensureEmptyProjectPageIsOpened(NewProjectFirstPage newProjectFirstPage, RemoteRobot remoteRobot) {
        int ideaVersionInt = UITestRunner.getIdeaVersionInt();
        boolean isEmptyProjectPageDisplayed = ideaVersionInt >= 20231 ? newProjectFirstPage.hasText("A basic project with free structure.") : newProjectFirstPage.hasText("A basic project that allows working with separate files and compiling Java and Kotlin classes.");
        if (!isEmptyProjectPageDisplayed) {
            CreateCloseUtils.waitForDialogsToDisappear(remoteRobot, Duration.ofSeconds(20L));
            newProjectFirstPage.selectNewProjectType(NewProjectType.EMPTY_PROJECT.toString());
        }
    }

    private static void waitForDialogsToDisappear(RemoteRobot remoteRobot, Duration timeout) {
        RepeatUtilsKt.waitFor((Duration)timeout, (Duration)Duration.ofSeconds(2L), (String)"Waiting for only the New Project dialog to remain open", () -> "Extra dialogs did not disappear within the timeout", () -> {
            List allDialogs = remoteRobot.findAll(ComponentFixture.class, Locators.byXpath((String)"//div[@class='MyDialog']"));
            return allDialogs.size() == 1;
        });
    }

    public static enum NewProjectType {
        PLAIN_JAVA("Java"),
        MAVEN("Maven"),
        GRADLE("Gradle"),
        EMPTY_PROJECT("Empty Project");

        private final String projectType;

        private NewProjectType(String projectType) {
            this.projectType = projectType;
        }

        public String toString() {
            return this.projectType;
        }
    }
}

