/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.intellij.openapi.ui.TestDialog;
import com.intellij.testFramework.LightPlatformTestCase;
import com.redhat.devtools.intellij.common.utils.DownloadHelper;
import com.redhat.devtools.intellij.common.utils.MessagesHelper;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class DownloadHelperTest
extends LightPlatformTestCase {
    private TestDialog previous;

    public void setUp() throws Exception {
        super.setUp();
        this.previous = MessagesHelper.setTestDialog(TestDialog.OK);
        FileUtils.deleteDirectory((File)new File("cache"));
    }

    protected void tearDown() throws Exception {
        MessagesHelper.setTestDialog(this.previous);
        super.tearDown();
        FileUtils.deleteDirectory((File)new File("cache"));
    }

    public void testThatGZIsDownloaded() throws IOException {
        String cmd = DownloadHelper.getInstance().downloadIfRequired("tkn", DownloadHelperTest.class.getResource("/tkn-test-gz.json"));
        DownloadHelperTest.assertNotNull((Object)cmd);
        DownloadHelperTest.assertEquals((String)("." + File.separatorChar + "cache" + File.separatorChar + "0.5.0" + File.separatorChar + "tkn"), (String)cmd);
        DownloadHelperTest.assertEquals((long)17L, (long)new File(cmd).length());
    }

    public void testThatTarGZIsDownloaded() throws IOException {
        String cmd = DownloadHelper.getInstance().downloadIfRequired("tkn", DownloadHelperTest.class.getResource("/tkn-test-tar.gz.json"));
        DownloadHelperTest.assertNotNull((Object)cmd);
        DownloadHelperTest.assertEquals((String)("." + File.separatorChar + "cache" + File.separatorChar + "0.5.0" + File.separatorChar + "tkn"), (String)cmd);
        DownloadHelperTest.assertEquals((long)17L, (long)new File(cmd).length());
    }
}

