/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.ui.treeStructure.Tree;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.swing.tree.TreePath;

public abstract class TreeAction
extends AnAction {
    private Class[] filters;
    private boolean acceptMultipleItems;

    public TreeAction(Class ... filters) {
        this.acceptMultipleItems = false;
        this.filters = filters;
    }

    public TreeAction(boolean acceptMultipleItems, Class ... filters) {
        this.acceptMultipleItems = acceptMultipleItems;
        this.filters = filters;
    }

    protected Tree getTree(AnActionEvent e) {
        return (Tree)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
    }

    protected Object getSelected(Tree tree) {
        return tree.getSelectionModel().getSelectionPath().getLastPathComponent();
    }

    protected Object[] getSelectedNodes(Tree tree) {
        TreePath[] treePaths = tree.getSelectionModel().getSelectionPaths();
        return Arrays.stream(treePaths).map(path -> path.getLastPathComponent()).toArray(Object[]::new);
    }

    protected Object adjust(Object selected) {
        return selected;
    }

    public void update(AnActionEvent e) {
        boolean visible = false;
        Tree comp = this.getTree(e);
        if (comp instanceof Tree) {
            visible = this.isVisible(this.getSelectedNodes(comp));
        }
        e.getPresentation().setVisible(visible);
    }

    public boolean isVisible(Object selected) {
        return Stream.of(this.filters).anyMatch(cl -> cl.isAssignableFrom(selected.getClass()));
    }

    public boolean isVisible(Object[] selected) {
        if (!this.acceptMultipleItems && selected.length > 1) {
            return false;
        }
        for (Object item : selected) {
            Object adjusted = this.adjust(item);
            if (adjusted != null && this.isVisible(adjusted)) continue;
            return false;
        }
        return true;
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        Tree tree = this.getTree(anActionEvent);
        TreePath[] selectedPaths = tree.getSelectionModel().getSelectionPaths();
        Object[] selected = this.getSelectedNodes(tree);
        this.actionPerformed(anActionEvent, selectedPaths, selected);
    }

    public abstract void actionPerformed(AnActionEvent var1, TreePath var2, Object var3);

    public void actionPerformed(AnActionEvent anActionEvent, TreePath[] path, Object[] selected) {
        this.actionPerformed(anActionEvent, path[0], selected[0]);
    }
}

