/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.redhat.devtools.intellij.common.utils.ToolsConfig;
import io.fabric8.kubernetes.api.model.AuthInfo;
import io.fabric8.kubernetes.api.model.AuthProviderConfig;
import io.fabric8.kubernetes.api.model.Config;
import io.fabric8.kubernetes.api.model.ConfigBuilder;
import io.fabric8.kubernetes.api.model.Context;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.client.internal.KubeConfigUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public class ConfigHelper {
    private static final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public static String getKubeConfigPath() {
        return System.getProperty("user.home") + "/.kube/config";
    }

    public static void saveKubeConfig(Config config) throws IOException {
        mapper.writeValue(new File(ConfigHelper.getKubeConfigPath()), (Object)config);
    }

    public static Config safeLoadKubeConfig() {
        try {
            return ConfigHelper.loadKubeConfig();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Config loadKubeConfig() throws IOException {
        return ConfigHelper.loadKubeConfig(ConfigHelper.getKubeConfigPath());
    }

    public static Config loadKubeConfig(String path) throws IOException {
        File f = new File(path);
        if (f.exists()) {
            return KubeConfigUtils.parseConfig((File)f);
        }
        return new ConfigBuilder().build();
    }

    public static boolean isKubeConfigParsable() {
        return ConfigHelper.isKubeConfigParsable(new File(ConfigHelper.getKubeConfigPath()));
    }

    public static boolean isKubeConfigParsable(File kubeConfig) {
        try {
            mapper.readValue(kubeConfig, Config.class);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static ToolsConfig loadToolsConfig() throws IOException {
        return ConfigHelper.loadToolsConfig(ConfigHelper.class.getResource("/tools.json"));
    }

    public static ToolsConfig loadToolsConfig(URL url) throws IOException {
        return (ToolsConfig)mapper.readValue(url, ToolsConfig.class);
    }

    public static NamedContext getCurrentContext() {
        try {
            Config config = ConfigHelper.loadKubeConfig();
            return KubeConfigUtils.getCurrentContext((Config)config);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean areEqual(Config kubeConfig, io.fabric8.kubernetes.client.Config clientConfig) {
        if (clientConfig == null) {
            return kubeConfig == null;
        }
        if (kubeConfig == null) {
            return false;
        }
        return ConfigHelper.areEqual(clientConfig.getCurrentContext(), KubeConfigUtils.getCurrentContext((Config)kubeConfig)) && ConfigHelper.areEqual(clientConfig.getContexts(), kubeConfig.getContexts()) && ConfigHelper.areEqualToken(kubeConfig, clientConfig);
    }

    public static boolean areEqual(NamedContext thisContext, NamedContext thatContext) {
        if (thisContext == null) {
            return thatContext == null;
        }
        if (thatContext == null) {
            return false;
        }
        if (!Objects.equals(thisContext.getName(), thatContext.getName())) {
            return false;
        }
        return ConfigHelper.areEqual(thisContext.getContext(), thatContext.getContext());
    }

    private static boolean areEqual(Context thisContext, Context thatContext) {
        if (thisContext == null) {
            return thatContext == null;
        }
        if (thatContext == null) {
            return false;
        }
        if (!Objects.equals(thisContext.getCluster(), thatContext.getCluster())) {
            return false;
        }
        if (!Objects.equals(thisContext.getNamespace(), thatContext.getNamespace())) {
            return false;
        }
        return Objects.equals(thisContext.getUser(), thatContext.getUser());
    }

    public static boolean areEqual(Collection<NamedContext> these, Collection<NamedContext> those) {
        if (these == null) {
            return those == null;
        }
        if (those == null) {
            return false;
        }
        return these.size() == those.size() && these.stream().allMatch(namedContext -> ConfigHelper.contains(namedContext, those));
    }

    private static boolean contains(NamedContext namedContext, Collection<NamedContext> namedContexts) {
        if (namedContexts == null || namedContexts.isEmpty()) {
            return false;
        }
        return namedContexts.stream().anyMatch(named -> ConfigHelper.areEqual(namedContext, named));
    }

    public static boolean areEqualToken(Config kubeConfig, io.fabric8.kubernetes.client.Config clientConfig) {
        return ConfigHelper.areEqualToken(ConfigHelper.getAuthInfo(kubeConfig), clientConfig);
    }

    private static AuthInfo getAuthInfo(Config kubeConfig) {
        NamedContext currentContext = KubeConfigUtils.getCurrentContext((Config)kubeConfig);
        return KubeConfigUtils.getUserAuthInfo((Config)kubeConfig, (Context)currentContext.getContext());
    }

    public static boolean areEqualToken(AuthInfo authInfo, io.fabric8.kubernetes.client.Config clientConfig) {
        String kubeConfigToken = ConfigHelper.getToken(authInfo);
        if (clientConfig == null || clientConfig.getOauthToken() == null) {
            return kubeConfigToken == null;
        }
        return clientConfig.getOauthToken().equals(kubeConfigToken);
    }

    private static String getToken(AuthInfo authInfo) {
        if (authInfo == null) {
            return null;
        }
        AuthProviderConfig authProviderConfig = authInfo.getAuthProvider();
        if (authProviderConfig == null) {
            return null;
        }
        Map config = authProviderConfig.getConfig();
        if (config == null || config.isEmpty()) {
            return null;
        }
        String accessToken = (String)config.get("access-token");
        if (accessToken != null && !accessToken.isEmpty()) {
            return accessToken;
        }
        String idToken = (String)config.get("id-token");
        if (idToken != null && !idToken.isEmpty()) {
            return idToken;
        }
        return null;
    }
}

