/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.redhat.devtools.intellij.common.utils.ConfigHelper;
import com.redhat.devtools.intellij.common.utils.HighSensitivityRegistrar;
import io.fabric8.kubernetes.api.model.Config;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.jetbrains.annotations.NotNull;

public class ConfigWatcher
implements Runnable {
    private final Path config;
    protected Listener listener;

    public ConfigWatcher(String config, Listener listener) {
        this(Paths.get(config, new String[0]), listener);
    }

    public ConfigWatcher(Path config, Listener listener) {
        this.config = config;
        this.listener = listener;
    }

    @Override
    public void run() {
        this.runOnConfigChange(() -> {
            Config config = this.loadConfig();
            if (config != null) {
                this.listener.onUpdate(this, config);
            }
        });
    }

    protected Config loadConfig() {
        try {
            return ConfigHelper.loadKubeConfig(this.config.toAbsolutePath().toString());
        }
        catch (IOException e) {
            return null;
        }
    }

    private void runOnConfigChange(Runnable runnable) {
        try (WatchService service = this.newWatchService();){
            WatchKey key;
            this.registerWatchService(service);
            while ((key = service.take()) != null) {
                key.pollEvents().stream().filter(this::isConfigPath).forEach(Void2 -> runnable.run());
                key.reset();
            }
        }
        catch (IOException | InterruptedException e) {
            Logger.getInstance(ConfigWatcher.class).warn("Could not watch kubernetes config file at " + this.config.toAbsolutePath(), (Throwable)e);
        }
    }

    protected WatchService newWatchService() throws IOException {
        return FileSystems.getDefault().newWatchService();
    }

    @NotNull
    private void registerWatchService(WatchService service) throws IOException {
        HighSensitivityRegistrar modifier = new HighSensitivityRegistrar();
        modifier.registerService(this.getWatchedPath(), new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE}, service);
    }

    protected boolean isConfigPath(WatchEvent<?> event) {
        Path path = this.getWatchedPath().resolve((Path)event.context());
        return path.equals(this.config);
    }

    private Path getWatchedPath() {
        return this.config.getParent();
    }

    public static interface Listener {
        public void onUpdate(ConfigWatcher var1, Config var2);
    }
}

