/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.tree;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ui.tree.StructureTreeModel;
import com.redhat.devtools.intellij.common.tree.MutableModel;
import java.util.Enumeration;
import java.util.function.Supplier;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MutableModelSynchronizer<T>
implements MutableModel.Listener<T> {
    protected final StructureTreeModel treeModel;
    private final AbstractTreeStructure structure;
    private final MutableModel<T> mutableModel;

    public MutableModelSynchronizer(StructureTreeModel treeModel, AbstractTreeStructure structure, MutableModel<T> mutableModel) {
        this.treeModel = treeModel;
        this.structure = structure;
        this.mutableModel = mutableModel;
        this.mutableModel.addListener(this);
    }

    private void invalidatePath(Supplier<TreePath> pathSupplier) {
        this.treeModel.getInvoker().runOrInvokeLater(() -> {
            TreePath path = (TreePath)pathSupplier.get();
            if (path.getLastPathComponent() == this.treeModel.getRoot()) {
                this.invalidateRoot();
            }
            this.treeModel.invalidate(path, true);
        });
    }

    private void invalidateRoot() {
        this.treeModel.invalidate();
    }

    private T getParentElement(T element) {
        return (T)this.structure.getParentElement(element);
    }

    protected TreePath getTreePath(T element) {
        TreePath path = this.isRootNode(element) ? new TreePath(this.treeModel.getRoot()) : this.findTreePath(element, (DefaultMutableTreeNode)this.treeModel.getRoot());
        return path != null ? path : new TreePath(this.treeModel.getRoot());
    }

    protected boolean isRootNode(T element) {
        NodeDescriptor descriptor = (NodeDescriptor)((DefaultMutableTreeNode)this.treeModel.getRoot()).getUserObject();
        return descriptor != null && descriptor.getElement() == element;
    }

    private TreePath findTreePath(T element, DefaultMutableTreeNode start) {
        if (element == null || start == null) {
            return null;
        }
        Enumeration<TreeNode> children = start.children();
        while (children.hasMoreElements()) {
            TreeNode child = children.nextElement();
            if (!(child instanceof DefaultMutableTreeNode)) continue;
            if (this.hasElement(element, (DefaultMutableTreeNode)child)) {
                return new TreePath(((DefaultMutableTreeNode)child).getPath());
            }
            TreePath path = this.findTreePath(element, (DefaultMutableTreeNode)child);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    private boolean hasElement(T element, DefaultMutableTreeNode node) {
        NodeDescriptor descriptor = (NodeDescriptor)node.getUserObject();
        return descriptor != null && descriptor.getElement() == element;
    }

    @Override
    public void onAdded(T element) {
        this.invalidatePath(() -> this.getTreePath(this.getParentElement(element)));
    }

    @Override
    public void onModified(T element) {
        this.invalidatePath(() -> this.getTreePath(element));
    }

    @Override
    public void onRemoved(T element) {
        this.invalidatePath(() -> this.getTreePath(this.getParentElement(element)));
    }
}

