/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.TtyConnector;
import com.redhat.devtools.intellij.common.CommonConstants;
import com.redhat.devtools.intellij.common.utils.UIHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.xmlgraphics.util.WriterOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalView;

public class ExecHelper {
    private static final ScheduledExecutorService SERVICE = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());

    public static void executeAfter(Runnable runnable, long delay, TimeUnit unit) {
        SERVICE.schedule(runnable, delay, unit);
    }

    public static void submit(Runnable runnable) {
        SERVICE.submit(runnable);
    }

    public static String execute(String executable, final boolean checkExitCode, File workingDirectory, Map<String, String> envs, String ... arguments) throws IOException {
        DefaultExecutor executor = new DefaultExecutor(){

            public boolean isFailure(int exitValue) {
                if (checkExitCode) {
                    return super.isFailure(exitValue);
                }
                return false;
            }
        };
        StringWriter writer = new StringWriter();
        PumpStreamHandler handler = new PumpStreamHandler((OutputStream)new WriterOutputStream((Writer)writer));
        executor.setStreamHandler((ExecuteStreamHandler)handler);
        executor.setWorkingDirectory(workingDirectory);
        CommandLine command = new CommandLine(executable).addArguments(arguments, false);
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        env.putAll(envs);
        try {
            executor.execute(command, env);
            return writer.toString();
        }
        catch (IOException e) {
            throw new IOException(e.getLocalizedMessage() + " " + writer.toString(), e);
        }
    }

    public static String execute(String executable, File workingDirectory, Map<String, String> envs, String ... arguments) throws IOException {
        return ExecHelper.execute(executable, true, workingDirectory, envs, arguments);
    }

    public static String execute(String executable, Map<String, String> envs, String ... arguments) throws IOException {
        return ExecHelper.execute(executable, true, new File(CommonConstants.HOME_FOLDER), envs, arguments);
    }

    public static String execute(String executable, String ... arguments) throws IOException {
        return ExecHelper.execute(executable, Collections.emptyMap(), arguments);
    }

    public static String execute(String executable, File workingDirectory, String ... arguments) throws IOException {
        return ExecHelper.execute(executable, true, workingDirectory, Collections.emptyMap(), arguments);
    }

    public static String execute(String executable, boolean checkExitCode, Map<String, String> envs, String ... arguments) throws IOException {
        return ExecHelper.execute(executable, checkExitCode, new File(CommonConstants.HOME_FOLDER), envs, arguments);
    }

    public static String execute(String executable, boolean checkExitCode, String ... arguments) throws IOException {
        return ExecHelper.execute(executable, checkExitCode, new File(CommonConstants.HOME_FOLDER), Collections.emptyMap(), arguments);
    }

    public static ExecResult executeWithResult(String executable, final boolean checkExitCode, File workingDirectory, Map<String, String> envs, String ... arguments) throws IOException {
        DefaultExecutor executor = new DefaultExecutor(){

            public boolean isFailure(int exitValue) {
                if (checkExitCode) {
                    return super.isFailure(exitValue);
                }
                return false;
            }
        };
        StringWriter outWriter = new StringWriter();
        StringWriter errWriter = new StringWriter();
        PumpStreamHandler handler = new PumpStreamHandler((OutputStream)new WriterOutputStream((Writer)outWriter), (OutputStream)new WriterOutputStream((Writer)errWriter));
        executor.setStreamHandler((ExecuteStreamHandler)handler);
        executor.setWorkingDirectory(workingDirectory);
        CommandLine command = new CommandLine(executable).addArguments(arguments, false);
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        env.putAll(envs);
        try {
            int exitCode = executor.execute(command, env);
            return new ExecResult(outWriter.toString(), errWriter.toString(), exitCode);
        }
        catch (IOException e) {
            throw new IOException(e.getLocalizedMessage() + " " + errWriter.toString(), e);
        }
    }

    public static ExecResult executeWithResult(String executable, Map<String, String> envs, String ... arguments) throws IOException {
        return ExecHelper.executeWithResult(executable, true, new File(CommonConstants.HOME_FOLDER), envs, arguments);
    }

    private static void executeWithTerminalInternal(Project project, String title, File workingDirectory, boolean waitForProcessExit, Map<String, String> envs, String ... command) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(command).directory(workingDirectory).redirectErrorStream(true);
        builder.environment().putAll(envs);
        Process p = builder.start();
        ExecHelper.linkProcessToTerminal(p, project, title, waitForProcessExit);
    }

    private static AbstractTerminalRunner createTerminalRunner(Project project, final Process process, final String title) {
        AbstractTerminalRunner runner = new AbstractTerminalRunner(project){

            public Process createProcess(@Nullable String s) {
                return process;
            }

            protected ProcessHandler createProcessHandler(Process process2) {
                return null;
            }

            protected String getTerminalConnectionName(Process process2) {
                return null;
            }

            protected TtyConnector createTtyConnector(Process process2) {
                return new ProcessTtyConnector(process2, StandardCharsets.UTF_8){

                    protected void resizeImmediately() {
                    }

                    public String getName() {
                        return title;
                    }

                    public boolean isConnected() {
                        return true;
                    }
                };
            }

            public String runningTargetName() {
                return null;
            }
        };
        return runner;
    }

    public static void ensureTerminalWindowsIsOpened(Project project) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Terminal");
        if (toolWindow != null) {
            ApplicationManager.getApplication().invokeAndWait(() -> toolWindow.show(null));
        }
    }

    public static void linkProcessToTerminal(Process p, Project project, String title, boolean waitForProcessExit) throws IOException {
        try {
            ExecHelper.ensureTerminalWindowsIsOpened(project);
            boolean isPost2018_3 = ApplicationInfo.getInstance().getBuild().getBaselineVersion() >= 183;
            RedirectedProcess process = new RedirectedProcess(p, true, isPost2018_3);
            AbstractTerminalRunner runner = ExecHelper.createTerminalRunner(project, process, title);
            TerminalOptionsProvider terminalOptions = (TerminalOptionsProvider)ServiceManager.getService(TerminalOptionsProvider.class);
            terminalOptions.setCloseSessionOnLogout(false);
            TerminalView view = TerminalView.getInstance((Project)project);
            Method[] method = new Method[1];
            Object[][] parameters = new Object[1][];
            try {
                method[0] = TerminalView.class.getMethod("createNewSession", Project.class, AbstractTerminalRunner.class);
                parameters[0] = new Object[]{project, runner};
            }
            catch (NoSuchMethodException e) {
                try {
                    method[0] = TerminalView.class.getMethod("createNewSession", AbstractTerminalRunner.class);
                    parameters[0] = new Object[]{runner};
                }
                catch (NoSuchMethodException e1) {
                    throw new IOException(e1);
                }
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                try {
                    method[0].invoke((Object)view, parameters[0]);
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            });
            if (waitForProcessExit && p.waitFor() != 0) {
                throw new IOException("Process returned exit code: " + p.exitValue(), null);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public static void executeWithTerminal(Project project, String title, File workingDirectory, boolean waitForProcessToExit, Map<String, String> envs, String ... command) throws IOException {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ExecHelper.execute(command[0], workingDirectory, envs, (String[])Arrays.stream(command).skip(1L).toArray(String[]::new));
        } else {
            ExecHelper.executeWithTerminalInternal(project, title, workingDirectory, waitForProcessToExit, envs, command);
        }
    }

    public static void executeWithTerminal(Project project, String title, File workingDirectory, String ... command) throws IOException {
        ExecHelper.executeWithTerminal(project, title, workingDirectory, true, Collections.emptyMap(), command);
    }

    public static void executeWithTerminal(Project project, String title, boolean waitForProcessToExit, Map<String, String> envs, String ... command) throws IOException {
        ExecHelper.executeWithTerminal(project, title, new File(CommonConstants.HOME_FOLDER), waitForProcessToExit, envs, command);
    }

    public static void executeWithTerminal(Project project, String title, boolean waitForProcessToExit, String ... command) throws IOException {
        ExecHelper.executeWithTerminal(project, title, new File(CommonConstants.HOME_FOLDER), waitForProcessToExit, Collections.emptyMap(), command);
    }

    public static void executeWithTerminal(Project project, String title, Map<String, String> envs, String ... command) throws IOException {
        ExecHelper.executeWithTerminal(project, title, new File(CommonConstants.HOME_FOLDER), true, envs, command);
    }

    public static void executeWithTerminal(Project project, String title, String ... command) throws IOException {
        ExecHelper.executeWithTerminal(project, title, new File(CommonConstants.HOME_FOLDER), true, Collections.emptyMap(), command);
    }

    public static void executeWithUI(Map<String, String> envs, Runnable initRunnable, Consumer<String> runnable, String ... command) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(command).directory(new File(CommonConstants.HOME_FOLDER)).redirectErrorStream(true);
        builder.environment().putAll(envs);
        Process p = builder.start();
        ExecHelper.linkProcessToUI(p, initRunnable, runnable);
    }

    public static void executeWithUI(Map<String, String> envs, Consumer<String> runnable, String ... command) throws IOException {
        ExecHelper.executeWithUI(envs, null, runnable, command);
    }

    private static void linkProcessToUI(Process p, Runnable initRunnable, Consumer<String> runnable) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (initRunnable != null) {
                UIHelper.executeInUI(initRunnable);
            }
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream(), "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                    UIHelper.executeInUI(() -> runnable.accept(sb.toString()));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    private static class RedirectedProcess
    extends Process {
        private final Process delegate;
        private final InputStream inputStream;

        private RedirectedProcess(Process delegate, boolean redirect, boolean delay) {
            this.delegate = delegate;
            this.inputStream = new RedirectedStream(delegate.getInputStream(), redirect, delay){};
        }

        @Override
        public OutputStream getOutputStream() {
            return this.delegate.getOutputStream();
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStream;
        }

        @Override
        public InputStream getErrorStream() {
            return this.delegate.getErrorStream();
        }

        @Override
        public int waitFor() throws InterruptedException {
            return this.delegate.waitFor();
        }

        @Override
        public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.waitFor(timeout, unit);
        }

        @Override
        public int exitValue() {
            return this.delegate.exitValue();
        }

        @Override
        public void destroy() {
            this.delegate.destroy();
        }

        @Override
        public Process destroyForcibly() {
            return this.delegate.destroyForcibly();
        }

        @Override
        public boolean isAlive() {
            return this.delegate.isAlive();
        }
    }

    private static class RedirectedStream
    extends FilterInputStream {
        private boolean emitLF = false;
        private final boolean redirect;
        private final boolean delay;

        private RedirectedStream(InputStream delegate, boolean redirect, boolean delay) {
            super(delegate);
            this.redirect = redirect;
            this.delay = delay;
        }

        @Override
        public synchronized int read() throws IOException {
            if (this.emitLF) {
                this.emitLF = false;
                return 10;
            }
            int c = super.read();
            if (this.redirect && c == 10) {
                this.emitLF = true;
                c = 13;
            }
            return c;
        }

        @Override
        public synchronized int read(@NotNull byte[] b) throws IOException {
            if (b == null) {
                RedirectedStream.$$$reportNull$$$0(0);
            }
            return this.read(b, 0, b.length);
        }

        @Override
        public synchronized int read(@NotNull byte[] b, int off, int len) throws IOException {
            int i;
            if (b == null) {
                RedirectedStream.$$$reportNull$$$0(1);
            }
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int c = this.read();
            if (c == -1) {
                if (this.delay) {
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return -1;
            }
            b[off] = (byte)c;
            try {
                for (i = 1; i < len && this.available() > 0 && (c = this.read()) != -1; ++i) {
                    b[off + i] = (byte)c;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return i;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/redhat/devtools/intellij/common/utils/ExecHelper$RedirectedStream", "read"));
        }
    }

    public static class ExecResult {
        private final String stdOut;
        @Nullable
        private final String stdErr;
        private final int exitCode;

        public ExecResult(String stdOut, @Nullable String stdErr, int exitCode) {
            this.stdOut = stdOut;
            this.stdErr = stdErr;
            this.exitCode = exitCode;
        }

        public String getStdOut() {
            return this.stdOut;
        }

        public String getStdErr() {
            return this.stdErr;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

