/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.kubernetes;

import com.redhat.devtools.intellij.common.kubernetes.ClusterInfo;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.VersionInfo;
import io.fabric8.openshift.client.OpenShiftClient;

public class ClusterHelper {
    private static String assemble(String major, String minor) {
        return major + '.' + minor;
    }

    public static ClusterInfo getClusterInfo(KubernetesClient client) {
        if (client.isAdaptable(OpenShiftClient.class).booleanValue()) {
            OpenShiftClient oclient;
            if (client instanceof OpenShiftClient) {
                oclient = (OpenShiftClient)client;
                client = new DefaultKubernetesClient(client.getConfiguration());
            } else {
                oclient = (OpenShiftClient)client.adapt(OpenShiftClient.class);
            }
            VersionInfo oVersion = oclient.getVersion();
            return new ClusterInfo(client.getVersion().getGitVersion(), true, oVersion != null && oVersion.getMajor() != null ? ClusterHelper.assemble(oVersion.getMajor(), oVersion.getMinor()) : "");
        }
        return new ClusterInfo(client.getVersion().getGitVersion(), false, "");
    }
}

