/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.io.HttpRequests;
import com.redhat.devtools.intellij.common.CommonConstants;
import com.redhat.devtools.intellij.common.utils.ConfigHelper;
import com.redhat.devtools.intellij.common.utils.ExecHelper;
import com.redhat.devtools.intellij.common.utils.ToolsConfig;
import com.twelvemonkeys.lang.Platform;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class DownloadHelper {
    private static final UnaryOperator<InputStream> UNCOMPRESSOR = input -> {
        try {
            return new CompressorStreamFactory().createCompressorInputStream(input);
        }
        catch (CompressorException e) {
            throw new RuntimeException(e);
        }
    };
    private static final UnaryOperator<InputStream> UNTAR = input -> new TarArchiveInputStream(input);
    private static final UnaryOperator<InputStream> UNZIP = input -> new ZipArchiveInputStream(input);
    private static final Map<String, UnaryOperator<InputStream>> MAPPERS = new HashMap<String, UnaryOperator<InputStream>>();
    private static DownloadHelper INSTANCE;

    private DownloadHelper() {
    }

    public static DownloadHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DownloadHelper();
        }
        return INSTANCE;
    }

    public String downloadIfRequired(String toolName, URL url) throws IOException {
        ToolsConfig config = ConfigHelper.loadToolsConfig(url);
        ToolsConfig.Tool tool = config.getTools().get(toolName);
        if (tool == null) {
            throw new IOException("Tool " + toolName + " not found in config file " + url);
        }
        final ToolsConfig.Platform platform = tool.getPlatforms().get(Platform.os().id());
        String command = platform.getCmdFileName();
        String version = this.getVersionFromPath(tool, platform);
        if (!this.areCompatible(version, tool.getVersionMatchRegExpr())) {
            final Path path = Paths.get(tool.getBaseDir().replace("$HOME", CommonConstants.HOME_FOLDER), "cache", tool.getVersion(), command);
            if (!Files.exists(path, new LinkOption[0])) {
                final Path dlFilePath = path.resolveSibling(platform.getDlFileName());
                final String cmd = path.toString();
                if (this.isDownloadAllowed(toolName, version, tool.getVersion())) {
                    command = (String)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<String, IOException>(null, "Downloading " + toolName, true){

                        public String compute(@NotNull ProgressIndicator progressIndicator) throws IOException {
                            if (progressIndicator == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return (String)HttpRequests.request((String)platform.getUrl().toString()).useProxy(true).connect(request -> {
                                DownloadHelper.downloadFile(request.getInputStream(), dlFilePath, progressIndicator, request.getConnection().getContentLength());
                                if (progressIndicator.isCanceled()) {
                                    throw new IOException("Cancelled");
                                }
                                DownloadHelper.this.uncompress(dlFilePath, path);
                                return cmd;
                            });
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/redhat/devtools/intellij/common/utils/DownloadHelper$1", "compute"));
                        }
                    });
                }
            } else {
                command = path.toString();
            }
        }
        return command;
    }

    public CompletableFuture<String> downloadIfRequiredAsync(String toolName, URL url) {
        CompletableFuture<String> result = new CompletableFuture<String>();
        ApplicationManager.getApplication().invokeLater(() -> {
            try {
                result.complete(this.downloadIfRequired(toolName, url));
            }
            catch (IOException e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    private boolean isDownloadAllowed(String tool, String currentVersion, String requiredVersion) {
        return Messages.showYesNoCancelDialog((String)(StringUtils.isEmpty((String)currentVersion) ? tool + " not found , do you want to download " + tool + " " + requiredVersion + " ?" : tool + " " + currentVersion + " found, required version is " + requiredVersion + ", do you want to download " + tool + " ?"), (String)(tool + " tool required"), (Icon)Messages.getQuestionIcon()) == 0;
    }

    private boolean areCompatible(String version, String versionMatchRegExpr) {
        boolean compatible = true;
        if (StringUtils.isNotBlank((String)versionMatchRegExpr)) {
            Pattern pattern = Pattern.compile(versionMatchRegExpr);
            compatible = pattern.matcher(version).matches();
        } else if (StringUtils.isBlank((String)version)) {
            compatible = false;
        }
        return compatible;
    }

    private String getVersionFromPath(ToolsConfig.Tool tool, ToolsConfig.Platform platform) {
        String version = "";
        try {
            Pattern pattern = Pattern.compile(tool.getVersionExtractRegExp());
            String[] arguments = tool.getVersionCmd().split(" ");
            String output = ExecHelper.execute(platform.getCmdFileName(), false, arguments);
            try (BufferedReader reader = new BufferedReader(new StringReader(output));){
                version = reader.lines().map(line -> pattern.matcher((CharSequence)line)).filter(matcher -> matcher.matches()).map(matcher -> matcher.group(1)).findFirst().orElse("");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return version;
    }

    private static void downloadFile(InputStream input, Path dlFileName, ProgressIndicator progressIndicator, long size) throws IOException {
        byte[] buffer = new byte[4096];
        Files.createDirectories(dlFileName.getParent(), new FileAttribute[0]);
        try (OutputStream output = Files.newOutputStream(dlFileName, new OpenOption[0]);){
            int lg;
            long accumulated = 0L;
            while ((lg = input.read(buffer)) > 0 && !progressIndicator.isCanceled()) {
                output.write(buffer, 0, lg);
                progressIndicator.setFraction((double)(accumulated += (long)lg) / (double)size);
            }
        }
    }

    private InputStream checkTar(InputStream stream) throws IOException {
        TarArchiveInputStream tarStream = new TarArchiveInputStream(stream);
        if (tarStream.getNextTarEntry() != null) {
            return tarStream;
        }
        throw new IOException("No TAR entry found in " + stream);
    }

    private InputStream mapStream(String filename, InputStream input) {
        String extension;
        while ((extension = FilenameUtils.getExtension((String)filename)) != null && MAPPERS.containsKey(extension)) {
            filename = FilenameUtils.removeExtension((String)filename);
            input = (InputStream)MAPPERS.get(extension).apply(input);
        }
        return input;
    }

    private void uncompress(Path dlFilePath, Path cmd) throws IOException {
        try (BufferedInputStream input = new BufferedInputStream(Files.newInputStream(dlFilePath, new OpenOption[0]));){
            InputStream subStream = this.mapStream(dlFilePath.toString(), input);
            if (subStream instanceof ArchiveInputStream) {
                ArchiveEntry entry;
                while ((entry = ((ArchiveInputStream)subStream).getNextEntry()) != null) {
                    this.save(subStream, cmd.resolveSibling(entry.getName()), entry.getSize());
                }
            } else {
                if (cmd.equals(dlFilePath)) {
                    cmd.toFile().setExecutable(true);
                    return;
                }
                this.save(subStream, cmd, -1L);
            }
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    private void save(InputStream source, Path destination, long length) throws IOException {
        try (OutputStream stream = Files.newOutputStream(destination, new OpenOption[0]);){
            if (length == -1L) {
                IOUtils.copy((InputStream)source, (OutputStream)stream);
            } else {
                IOUtils.copyLarge((InputStream)source, (OutputStream)stream, (long)0L, (long)length);
            }
        }
        destination.toFile().setExecutable(true);
    }

    static {
        MAPPERS.put("gz", UNCOMPRESSOR);
        MAPPERS.put("zip", UNZIP);
        MAPPERS.put("tar", UNTAR);
    }
}

