/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YAMLHelper {
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());

    public static String getStringValueFromYAML(String yamlAsString, String[] path) throws IOException {
        JsonNode nodeValue = YAMLHelper.getValueFromYAML(yamlAsString, path);
        if (nodeValue == null || !nodeValue.isTextual()) {
            return null;
        }
        return nodeValue.asText();
    }

    public static JsonNode getValueFromYAML(String yamlAsString, String[] path) throws IOException {
        if (yamlAsString == null) {
            return null;
        }
        JsonNode node = YAML_MAPPER.readTree(yamlAsString);
        Pattern arrayPattern = Pattern.compile("(\\w+)(\\[(\\d)\\])*");
        for (String field : path) {
            int index = -1;
            Matcher match = arrayPattern.matcher(field);
            if (match.matches() && match.group(3) != null) {
                field = match.group(1);
                index = Integer.parseInt(match.group(3));
            }
            if (!node.has(field) || index != -1 && !node.get(field).has(index)) {
                return null;
            }
            node = node.get(field);
            if (index == -1) continue;
            node = node.get(index);
        }
        return node;
    }

    public static String JSONToYAML(JsonNode json) throws IOException {
        if (json == null) {
            return "";
        }
        try {
            return new YAMLMapper().configure(YAMLGenerator.Feature.WRITE_DOC_START_MARKER, false).configure(YAMLGenerator.Feature.MINIMIZE_QUOTES, true).writeValueAsString((Object)json);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    public static JsonNode YAMLToJsonNode(String yaml) throws IOException {
        return YAML_MAPPER.readTree(yaml);
    }

    public static JsonNode URLToJSON(URL file) throws IOException {
        if (file == null) {
            return null;
        }
        return YAML_MAPPER.readTree(file);
    }

    public static JsonNode editValueInYAML(String yamlAsString, String[] fieldnames, String value) throws IOException {
        JsonNode node;
        if (yamlAsString == null) {
            return null;
        }
        JsonNode tmpNode = node = YAML_MAPPER.readTree(yamlAsString);
        Pattern arrayPattern = Pattern.compile("(\\w+)(\\[(\\d)\\])*");
        for (int i = 0; i < fieldnames.length; ++i) {
            String fieldname = fieldnames[i];
            int index = -1;
            Matcher match = arrayPattern.matcher(fieldname);
            if (match.matches() && match.group(3) != null) {
                fieldname = match.group(1);
                index = Integer.parseInt(match.group(3));
            }
            if (!tmpNode.has(fieldname) || index != -1 && !tmpNode.get(fieldname).has(index)) {
                return null;
            }
            if (i == fieldnames.length - 1) {
                ((ObjectNode)tmpNode).put(fieldname, value);
                continue;
            }
            tmpNode = tmpNode.get(fieldname);
            if (index == -1) continue;
            tmpNode = tmpNode.get(index);
        }
        return node;
    }

    public static JsonNode addLabelToResource(String yaml, String labelKey, String labelValue) throws IOException {
        ObjectNode resource = (ObjectNode)YAMLHelper.YAMLToJsonNode(yaml);
        ObjectNode metadata = !resource.has("metadata") ? YAML_MAPPER.createObjectNode() : (ObjectNode)resource.get("metadata");
        if (!metadata.has("labels")) {
            ObjectNode newLabel = YAML_MAPPER.createObjectNode();
            newLabel.put(labelKey, labelValue);
            metadata.set("labels", (JsonNode)newLabel);
        } else if (!metadata.get("labels").has(labelKey)) {
            ((ObjectNode)metadata.get("labels")).put(labelKey, labelValue);
        }
        resource.set("metadata", (JsonNode)metadata);
        return resource;
    }

    public static JsonNode removeLabelFromResource(String yaml, String labelKey) throws IOException {
        ObjectNode resource = (ObjectNode)YAMLHelper.YAMLToJsonNode(yaml);
        ObjectNode metadata = !resource.has("metadata") ? YAML_MAPPER.createObjectNode() : (ObjectNode)resource.get("metadata");
        if (metadata.has("labels") && metadata.get("labels").has(labelKey)) {
            ((ObjectNode)metadata.get("labels")).remove(labelKey);
            if (metadata.get("labels").size() == 0) {
                metadata.remove("labels");
            }
        }
        resource.set("metadata", (JsonNode)metadata);
        return resource;
    }
}

