/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.redhat.devtools.intellij.common.utils.ConfigHelper;
import io.fabric8.kubernetes.api.model.AuthInfo;
import io.fabric8.kubernetes.api.model.AuthProviderConfig;
import io.fabric8.kubernetes.api.model.Config;
import io.fabric8.kubernetes.api.model.Context;
import io.fabric8.kubernetes.api.model.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.NamedContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;

public class ConfigHelperTest {
    private static final NamedContext ctx1 = new NamedContext(new Context("cluster1", null, "namespace1", "papa smurf"), "papa smurfs context");
    private static final NamedAuthInfo user1 = new NamedAuthInfo(ctx1.getContext().getUser(), ConfigHelperTest.authInfo(null, ConfigHelperTest.authProviderConfig("token1")));
    private static final NamedContext ctx2 = new NamedContext(new Context("cluster2", null, "namespace2", "grumpy smurf"), "grumpy smurfs context");
    private static final NamedAuthInfo user2 = new NamedAuthInfo(ctx2.getContext().getUser(), ConfigHelperTest.authInfo(null, ConfigHelperTest.authProviderConfig("token2")));
    private static final NamedContext ctx3 = new NamedContext(new Context("cluster3", null, "namespace3", "smurfette"), "smurfettes context");
    private static final NamedAuthInfo user3 = new NamedAuthInfo(ctx3.getContext().getUser(), ConfigHelperTest.authInfo(null, ConfigHelperTest.authProviderConfig("token3")));
    private static final NamedContext ctx4 = new NamedContext(new Context("cluster4", null, "namespace4", "jokey smurf"), "jokey smurfs context");
    private static final NamedAuthInfo user4 = new NamedAuthInfo(ctx4.getContext().getUser(), ConfigHelperTest.authInfo(null, ConfigHelperTest.authProviderConfig("token4")));
    private static final NamedContext ctx5 = new NamedContext(new Context("cluster2", null, "namespace2", "azrael"), "azraels context");
    private static final NamedAuthInfo user5 = new NamedAuthInfo(ctx5.getContext().getUser(), ConfigHelperTest.authInfo("token1", null));
    private static final List<NamedAuthInfo> allUsers = Arrays.asList(user1, user2, user3, user4, user5);
    private static final List<NamedContext> allContexts = Arrays.asList(ctx1, ctx2, ctx3, ctx5);

    @Test
    public void identical_namedContexts_should_be_equal() {
        boolean equal = ConfigHelper.areEqual((NamedContext)ctx1, (NamedContext)ConfigHelperTest.clone(ctx1));
        Assertions.assertThat((boolean)equal).isTrue();
    }

    @Test
    public void null_namedContexts_should_not_be_equal_to_non_null_namedContext() {
        boolean equal = ConfigHelper.areEqual((NamedContext)ctx1, null);
        Assertions.assertThat((boolean)equal).isFalse();
    }

    @Test
    public void non_null_namedContexts_should_not_be_equal_to_null_namedContext() {
        boolean equal = ConfigHelper.areEqual(null, (NamedContext)ctx1);
        Assertions.assertThat((boolean)equal).isFalse();
    }

    @Test
    public void namedContexts_with_different_cluster_should_NOT_be_equal() {
        NamedContext differentCluster = ConfigHelperTest.clone(ctx1);
        differentCluster.getContext().setCluster("imperial fleet");
        boolean equal = ConfigHelper.areEqual((NamedContext)ctx1, (NamedContext)differentCluster);
        Assertions.assertThat((boolean)equal).isFalse();
    }

    @Test
    public void namedContexts_with_different_namespace_should_NOT_be_equal() {
        NamedContext differentNamespace = ConfigHelperTest.clone(ctx1);
        differentNamespace.getContext().setNamespace("stormtroopers");
        boolean equal = ConfigHelper.areEqual((NamedContext)ctx1, (NamedContext)differentNamespace);
        Assertions.assertThat((boolean)equal).isFalse();
    }

    @Test
    public void namedContexts_with_different_user_should_NOT_be_equal() {
        NamedContext differentUser = ConfigHelperTest.clone(ctx1);
        differentUser.getContext().setUser("lord vader");
        boolean equal = ConfigHelper.areEqual((NamedContext)ctx1, (NamedContext)differentUser);
        Assertions.assertThat((boolean)equal).isFalse();
    }

    @Test
    public void namedContexts_with_different_name_should_NOT_be_equal() {
        NamedContext differentName = ConfigHelperTest.clone(ctx1);
        differentName.setName("imperial fleet");
        boolean equal = ConfigHelper.areEqual((NamedContext)ctx1, (NamedContext)differentName);
        Assertions.assertThat((boolean)equal).isFalse();
    }

    @Test
    public void namedContexts_with_same_members_should_be_equal() {
        boolean equal = ConfigHelper.areEqual(Arrays.asList(ctx1, ctx2), Arrays.asList(ConfigHelperTest.clone(ctx1), ConfigHelperTest.clone(ctx2)));
        Assertions.assertThat((boolean)equal).isTrue();
    }

    @Test
    public void namedContexts_with_additional_member_should_NOT_be_equal() {
        boolean equal = ConfigHelper.areEqual(Arrays.asList(ctx1, ctx2), Arrays.asList(ConfigHelperTest.clone(ctx1), ConfigHelperTest.clone(ctx2), ctx3));
        Assertions.assertThat((boolean)equal).isFalse();
    }

    @Test
    public void namedContexts_with_different_members_should_NOT_be_equal() {
        List<NamedContext> additionalMember = ConfigHelperTest.clone(allContexts);
        additionalMember.add(ctx4);
        boolean equal = ConfigHelper.areEqual(allContexts, additionalMember);
        Assertions.assertThat((boolean)equal).isFalse();
    }

    @Test
    public void authInfo_with_same_provider_token_should_be_equal() {
        String token = "gargamel";
        AuthInfo authInfo = ConfigHelperTest.authInfo(null, ConfigHelperTest.authProviderConfig("id-token", token));
        io.fabric8.kubernetes.client.Config config = ConfigHelperTest.clientConfig(token);
        boolean equal = ConfigHelper.areEqualToken((AuthInfo)authInfo, (io.fabric8.kubernetes.client.Config)config);
        Assertions.assertThat((boolean)equal).isTrue();
    }

    @Test
    public void authInfo_with_same_authinfo_token_should_be_equal() {
        String token = "token42";
        AuthInfo authInfo = ConfigHelperTest.authInfo(token, null);
        io.fabric8.kubernetes.client.Config config = ConfigHelperTest.clientConfig(token);
        boolean equal = ConfigHelper.areEqualToken((AuthInfo)authInfo, (io.fabric8.kubernetes.client.Config)config);
        Assertions.assertThat((boolean)equal).isTrue();
    }

    @Test
    public void authInfo_with_different_provider_token_should_NOT_be_equal() {
        AuthInfo authInfo = ConfigHelperTest.authInfo(null, ConfigHelperTest.authProviderConfig("id-token", "gargamel"));
        io.fabric8.kubernetes.client.Config config = ConfigHelperTest.clientConfig("azrael");
        boolean equal = ConfigHelper.areEqualToken((AuthInfo)authInfo, (io.fabric8.kubernetes.client.Config)config);
        Assertions.assertThat((boolean)equal).isFalse();
    }

    @Test
    public void authInfo_with_same_provider_token_in_access_token_should_be_equal() {
        String token = "gargamel";
        AuthInfo authInfo = ConfigHelperTest.authInfo(null, ConfigHelperTest.authProviderConfig("access-token", token));
        io.fabric8.kubernetes.client.Config config = ConfigHelperTest.clientConfig(token);
        boolean equal = ConfigHelper.areEqualToken((AuthInfo)authInfo, (io.fabric8.kubernetes.client.Config)config);
        Assertions.assertThat((boolean)equal).isTrue();
    }

    @Test
    public void kubeConfig_and_clientConfig_are_equal_if_same_in_currentContext_contexts_and_provider_token() {
        Config kubeConfig = ConfigHelperTest.kubeConfig(ctx2, allContexts, allUsers);
        io.fabric8.kubernetes.client.Config clientConfig = ConfigHelperTest.clientConfig(ConfigHelperTest.getUser(ctx2, allUsers), ConfigHelperTest.clone(ctx2), ConfigHelperTest.clone(allContexts));
        boolean equal = ConfigHelper.areEqual((Config)kubeConfig, (io.fabric8.kubernetes.client.Config)clientConfig);
        Assertions.assertThat((boolean)equal).isTrue();
    }

    @Test
    public void kubeConfig_and_clientConfig_are_equal_if_same_in_currentContext_contexts_and_authinfo_token() {
        Config kubeConfig = ConfigHelperTest.kubeConfig(ctx5, allContexts, allUsers);
        io.fabric8.kubernetes.client.Config clientConfig = ConfigHelperTest.clientConfig(ConfigHelperTest.getUser(ctx5, allUsers), ConfigHelperTest.clone(ctx5), ConfigHelperTest.clone(allContexts));
        boolean equal = ConfigHelper.areEqual((Config)kubeConfig, (io.fabric8.kubernetes.client.Config)clientConfig);
        Assertions.assertThat((boolean)equal).isTrue();
    }

    @Test
    public void kubeConfig_and_clientConfig_are_NOT_equal_if_NOT_same_in_currentContext() {
        Config kubeConfig = ConfigHelperTest.kubeConfig(ctx2, allContexts, allUsers);
        io.fabric8.kubernetes.client.Config clientConfig = ConfigHelperTest.clientConfig(ConfigHelperTest.getUser(ctx3, allUsers), ConfigHelperTest.clone(ctx3), ConfigHelperTest.clone(allContexts));
        boolean equal = ConfigHelper.areEqual((Config)kubeConfig, (io.fabric8.kubernetes.client.Config)clientConfig);
        Assertions.assertThat((boolean)equal).isFalse();
    }

    @Test
    public void kubeConfig_and_clientConfig_are_NOT_equal_if_contexts_has_additional_member() {
        ArrayList<NamedContext> allContextsWithAddition = new ArrayList<NamedContext>(allContexts);
        allContextsWithAddition.add(ctx4);
        Config kubeConfig = ConfigHelperTest.kubeConfig(ctx2, allContextsWithAddition, allUsers);
        io.fabric8.kubernetes.client.Config clientConfig = ConfigHelperTest.clientConfig(ConfigHelperTest.getUser(ctx2, allUsers), ConfigHelperTest.clone(ctx2), allContexts);
        boolean equal = ConfigHelper.areEqual((Config)kubeConfig, (io.fabric8.kubernetes.client.Config)clientConfig);
        Assertions.assertThat((boolean)equal).isFalse();
    }

    @Test
    public void kubeConfig_and_clientConfig_are_NOT_equal_if_token_is_different() {
        Config kubeConfig = ConfigHelperTest.kubeConfig(ctx2, allContexts, allUsers);
        io.fabric8.kubernetes.client.Config clientConfig = ConfigHelperTest.clientConfig("token 42", ConfigHelperTest.clone(ctx2), allContexts);
        boolean equal = ConfigHelper.areEqual((Config)kubeConfig, (io.fabric8.kubernetes.client.Config)clientConfig);
        Assertions.assertThat((boolean)equal).isFalse();
    }

    private static AuthInfo authInfo(String token, AuthProviderConfig config) {
        AuthInfo authInfo = new AuthInfo();
        authInfo.setAuthProvider(config);
        authInfo.setToken(token);
        return authInfo;
    }

    private static AuthProviderConfig authProviderConfig(String tokenValue) {
        return ConfigHelperTest.authProviderConfig("id-config", tokenValue);
    }

    private static AuthProviderConfig authProviderConfig(String tokenKey, String tokenValue) {
        AuthProviderConfig authProviderConfig = new AuthProviderConfig();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(tokenKey, tokenValue);
        authProviderConfig.setConfig(config);
        return authProviderConfig;
    }

    private static io.fabric8.kubernetes.client.Config clientConfig(String token) {
        return ConfigHelperTest.clientConfig(token, null, Collections.emptyList());
    }

    private static io.fabric8.kubernetes.client.Config clientConfig(NamedAuthInfo user, NamedContext currentContext, List<NamedContext> contexts) {
        return ConfigHelperTest.clientConfig(user.getUser().getToken(), currentContext, contexts);
    }

    private static io.fabric8.kubernetes.client.Config clientConfig(String token, NamedContext currentContext, List<NamedContext> contexts) {
        io.fabric8.kubernetes.client.Config config = (io.fabric8.kubernetes.client.Config)Mockito.mock(io.fabric8.kubernetes.client.Config.class);
        ((io.fabric8.kubernetes.client.Config)Mockito.doReturn((Object)token).when((Object)config)).getOauthToken();
        ((io.fabric8.kubernetes.client.Config)Mockito.doReturn((Object)currentContext).when((Object)config)).getCurrentContext();
        ((io.fabric8.kubernetes.client.Config)Mockito.doReturn(contexts).when((Object)config)).getContexts();
        return config;
    }

    private static Config kubeConfig(NamedContext currentContext, List<NamedContext> contexts, List<NamedAuthInfo> users) {
        Config config = (Config)Mockito.mock(Config.class);
        ((Config)Mockito.doReturn((Object)currentContext.getName()).when((Object)config)).getCurrentContext();
        ((Config)Mockito.doReturn(contexts).when((Object)config)).getContexts();
        ((Config)Mockito.doReturn(users).when((Object)config)).getUsers();
        return config;
    }

    private static List<NamedContext> clone(List<NamedContext> namedContexts) {
        return namedContexts.stream().map(ConfigHelperTest::clone).collect(Collectors.toList());
    }

    private static NamedContext clone(NamedContext namedContext) {
        Context context = namedContext.getContext();
        return new NamedContext(new Context(context.getCluster(), context.getExtensions(), context.getNamespace(), context.getUser()), namedContext.getName());
    }

    private static NamedAuthInfo getUser(NamedContext context, Collection<NamedAuthInfo> users) {
        return users.stream().filter(user -> user.getName() == context.getContext().getUser()).findAny().orElse(null);
    }
}

