/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.tree;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class LazyMutableTreeNode
extends DefaultMutableTreeNode {
    protected boolean loaded = false;
    private final transient List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    public LazyMutableTreeNode() {
    }

    public LazyMutableTreeNode(Object userObject) {
        super(userObject);
    }

    public LazyMutableTreeNode(Object userObject, boolean allowsChildren) {
        super(userObject, allowsChildren);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void load() {
        this.loaded = true;
    }

    public void reload() {
        this.loaded = false;
        this.removeAllChildren();
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyChildAdded(Object child, int index) {
        for (ChangeListener listener : this.listeners) {
            listener.onChildAdded(this, child, index);
        }
    }

    protected void notifyChildRemoved(Object child, int index) {
        for (ChangeListener listener : this.listeners) {
            listener.onChildRemoved(this, child, index);
        }
    }

    protected void notifyChildrensRemoved() {
        for (ChangeListener listener : this.listeners) {
            listener.onChildrensRemoved(this);
        }
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        super.insert(newChild, childIndex);
        this.notifyChildAdded(newChild, childIndex);
    }

    @Override
    public void remove(MutableTreeNode aChild) {
        int index = this.children.indexOf(aChild);
        super.remove(aChild);
        this.notifyChildRemoved(aChild, index);
    }

    @Override
    public void removeAllChildren() {
        super.removeAllChildren();
        this.notifyChildrensRemoved();
    }

    public static interface ChangeListener {
        public void onChildAdded(LazyMutableTreeNode var1, Object var2, int var3);

        public void onChildRemoved(LazyMutableTreeNode var1, Object var2, int var3);

        public void onChildrensRemoved(LazyMutableTreeNode var1);
    }
}

