/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.IdeaWideAuthenticator;
import com.intellij.util.net.IdeaWideProxySelector;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;

public class NetworkUtils {
    public static OkHttpClient getClient() {
        HttpConfigurable httpConfigurable = HttpConfigurable.getInstance();
        IdeaWideProxySelector ideaWideProxySelector = new IdeaWideProxySelector(httpConfigurable);
        IdeaWideAuthenticator ideaWideAuthenticator = new IdeaWideAuthenticator(httpConfigurable);
        Authenticator proxyAuthenticator = NetworkUtils.getProxyAuthenticator(ideaWideAuthenticator);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.proxySelector((ProxySelector)ideaWideProxySelector).proxyAuthenticator(proxyAuthenticator);
        return builder.build();
    }

    private static Authenticator getProxyAuthenticator(IdeaWideAuthenticator ideaWideAuthenticator) {
        Authenticator proxyAuthenticator = null;
        if (Objects.nonNull(ideaWideAuthenticator)) {
            proxyAuthenticator = (route, response) -> {
                PasswordAuthentication authentication = ideaWideAuthenticator.getPasswordAuthentication();
                String credential = Credentials.basic((String)authentication.getUserName(), (String)Arrays.toString(authentication.getPassword()));
                return response.request().newBuilder().header("Proxy-Authorization", credential).build();
            };
        }
        return proxyAuthenticator;
    }

    @NotNull
    public static Map<String, String> buildEnvironmentVariables(String url) throws URISyntaxException {
        URI uri;
        boolean FIRST = false;
        String HTTP_PROXY = "HTTP_PROXY";
        String HTTPS_PROXY = "HTTPS_PROXY";
        String ALL_PROXY = "ALL_PROXY";
        HashSet proxyEnvironmentVariables = Sets.newHashSet((Object[])new String[]{"HTTP_PROXY", "HTTPS_PROXY", "ALL_PROXY"});
        HashMap<String, String> environmentVariables = new HashMap<String, String>(6);
        HttpConfigurable httpConfigurable = HttpConfigurable.getInstance();
        IdeaWideProxySelector ideaWideProxySelector = new IdeaWideProxySelector(httpConfigurable);
        List proxies = ideaWideProxySelector.select(uri = new URI(url));
        if (!proxies.isEmpty()) {
            Proxy proxy = (Proxy)proxies.get(0);
            Proxy.Type type = proxy.type();
            switch (type) {
                case HTTP: 
                case SOCKS: {
                    SocketAddress address = proxy.address();
                    if (!(address instanceof InetSocketAddress)) break;
                    InetSocketAddress socketAddress = (InetSocketAddress)address;
                    InetAddress inetAddress = socketAddress.getAddress();
                    int port = socketAddress.getPort();
                    IdeaWideAuthenticator ideaWideAuthenticator = new IdeaWideAuthenticator(httpConfigurable);
                    Optional<PasswordAuthentication> optionalPasswordAuthentication = Optional.ofNullable(ideaWideAuthenticator.getPasswordAuthentication());
                    String userName = null;
                    String password = null;
                    if (optionalPasswordAuthentication.isPresent()) {
                        PasswordAuthentication passwordAuthentication = optionalPasswordAuthentication.get();
                        userName = passwordAuthentication.getUserName();
                        password = Arrays.toString(passwordAuthentication.getPassword());
                    }
                    String finalUserName = userName;
                    String finalPassword = password;
                    proxyEnvironmentVariables.forEach(envVarName -> {
                        String envVarValue = NetworkUtils.buildHttpProxy(type, finalUserName, finalPassword, inetAddress, port);
                        environmentVariables.put((String)envVarName, envVarValue);
                        environmentVariables.put(envVarName.toLowerCase(), envVarValue);
                    });
                }
            }
        }
        HashMap<String, String> hashMap = environmentVariables;
        if (hashMap == null) {
            NetworkUtils.$$$reportNull$$$0(0);
        }
        return hashMap;
    }

    @NotNull
    private static String buildHttpProxy(Proxy.Type type, String userName, String password, InetAddress address, int port) {
        StringBuilder builder = new StringBuilder();
        switch (type) {
            case HTTP: {
                builder.append("http://");
                break;
            }
            case SOCKS: {
                builder.append("socks://");
            }
        }
        if (StringUtil.isNotEmpty((String)userName) && StringUtil.isNotEmpty((String)password)) {
            builder.append(userName).append(":").append(password).append("@");
        }
        builder.append(address.getHostAddress()).append(":").append(port);
        String string = builder.toString();
        if (string == null) {
            NetworkUtils.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/redhat/devtools/intellij/common/utils/NetworkUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildEnvironmentVariables";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHttpProxy";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

