/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.validation;

import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLValue;

public class KubernetesTypeInfo {
    private String apiGroup = "";
    private String kind = "";

    public KubernetesTypeInfo(String apiGroup, String kind) {
        this.apiGroup = apiGroup;
        this.kind = kind;
    }

    public KubernetesTypeInfo() {
    }

    public static KubernetesTypeInfo extractMeta(PsiFile file) {
        KubernetesTypeInfo info = new KubernetesTypeInfo();
        if (file instanceof JsonFile) {
            KubernetesTypeInfo.extractJsonMeta((JsonFile)file, info);
        } else if (file instanceof YAMLFile) {
            KubernetesTypeInfo.extractYAMLMeta((YAMLFile)file, info);
        }
        return info;
    }

    private static void extractJsonMeta(JsonFile file, final KubernetesTypeInfo info) {
        JsonValue content = file.getTopLevelValue();
        if (content != null) {
            content.acceptChildren(new PsiElementVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (element instanceof JsonProperty) {
                        JsonProperty property = (JsonProperty)element;
                        if (property.getName().equals("apiVersion")) {
                            info.setApiGroup(property.getValue().getText());
                        } else if (property.getName().equals("kind")) {
                            info.setKind(property.getValue().getText());
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/redhat/devtools/intellij/common/validation/KubernetesTypeInfo$1", "visitElement"));
                }
            });
        }
    }

    private static void extractYAMLMeta(YAMLFile file, final KubernetesTypeInfo info) {
        YAMLValue content;
        if (!file.getDocuments().isEmpty() && (content = ((YAMLDocument)file.getDocuments().get(0)).getTopLevelValue()) != null) {
            content.acceptChildren(new PsiElementVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (element instanceof YAMLKeyValue) {
                        YAMLKeyValue property = (YAMLKeyValue)element;
                        if (property.getKeyText().equals("apiVersion")) {
                            info.setApiGroup(property.getValueText());
                        } else if (property.getKeyText().equals("kind")) {
                            info.setKind(property.getValueText());
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/redhat/devtools/intellij/common/validation/KubernetesTypeInfo$2", "visitElement"));
                }
            });
        }
    }

    public String getApiGroup() {
        return this.apiGroup;
    }

    public void setApiGroup(String apiGroup) {
        this.apiGroup = apiGroup;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KubernetesTypeInfo that = (KubernetesTypeInfo)o;
        return Objects.equals(this.apiGroup, that.apiGroup) && Objects.equals(this.kind, that.kind);
    }

    public int hashCode() {
        return Objects.hash(this.apiGroup, this.kind);
    }

    public String toString() {
        return this.apiGroup + '#' + this.kind;
    }

    public static KubernetesTypeInfo fromFileName(String filename) {
        int index = filename.indexOf(95);
        String apiGroup = index != -1 ? filename.substring(0, index) : "";
        String kind = index != -1 ? filename.substring(index + 1) : filename;
        index = kind.lastIndexOf(46);
        kind = index != -1 ? kind.substring(0, index) : kind;
        return new KubernetesTypeInfo(apiGroup, kind);
    }
}

