/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.tree;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.util.ui.tree.TreeUtil;
import com.redhat.devtools.intellij.common.tree.LinkElement;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class TreeHelper {
    public static TreePath getPathForLocation(JTree tree, int x, int y) {
        TreePath path = tree.getClosestPathForLocation(x, y);
        Rectangle bounds = tree.getPathBounds(path);
        return bounds != null && bounds.y <= y && y < bounds.y + bounds.height ? path : null;
    }

    public static void addLinkSupport(final JTree tree) {
        tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path = TreeHelper.getPathForLocation(tree, e.getX(), e.getY());
                Object object = TreeUtil.getLastUserObject((TreePath)path);
                if (!(object instanceof LinkElement) && object instanceof NodeDescriptor) {
                    object = ((NodeDescriptor)object).getElement();
                }
                if (object instanceof LinkElement) {
                    ((LinkElement)object).execute();
                }
            }
        });
    }
}

