/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.redhat.devtools.intellij.common.utils.ConfigHelper;
import com.redhat.devtools.intellij.common.utils.ToolsConfig;
import java.io.IOException;
import java.net.URL;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ToolsConfigTest {
    private static ToolsConfig config;

    @BeforeClass
    public static void init() throws IOException {
        config = ConfigHelper.loadToolsConfig((URL)ToolsConfig.class.getResource("/tkn-test.json"));
    }

    @Test
    public void verifyThatConfigCanLoad() throws IOException {
        Assert.assertNotNull((Object)config);
    }

    @Test
    public void verifyThatConfigReturnsTools() throws IOException {
        Assert.assertNotNull((Object)config);
        ToolsConfig.Tool tool = (ToolsConfig.Tool)config.getTools().get("tkn");
        Assert.assertNotNull((Object)tool);
    }

    @Test
    public void verifyThatConfigReturnsVersion() throws IOException {
        Assert.assertNotNull((Object)config);
        ToolsConfig.Tool tool = (ToolsConfig.Tool)config.getTools().get("tkn");
        Assert.assertNotNull((Object)tool);
        Assert.assertEquals((Object)"0.5.0", (Object)tool.getVersion());
    }

    @Test
    public void verifyThatConfigReturnsVersionCmd() throws IOException {
        Assert.assertNotNull((Object)config);
        ToolsConfig.Tool tool = (ToolsConfig.Tool)config.getTools().get("tkn");
        Assert.assertNotNull((Object)tool);
        Assert.assertEquals((Object)"version", (Object)tool.getVersionCmd());
    }

    @Test
    public void verifyThatConfigReturnsVersionExtractRegExp() throws IOException {
        Assert.assertNotNull((Object)config);
        ToolsConfig.Tool tool = (ToolsConfig.Tool)config.getTools().get("tkn");
        Assert.assertNotNull((Object)tool);
        Assert.assertEquals((Object)"Client version: (\\d+[\\.\\d+]*)\\s.*", (Object)tool.getVersionExtractRegExp());
    }

    @Test
    public void verifyThatConfigReturnsVersionMatchRegExp() throws IOException {
        Assert.assertNotNull((Object)config);
        ToolsConfig.Tool tool = (ToolsConfig.Tool)config.getTools().get("tkn");
        Assert.assertNotNull((Object)tool);
        Assert.assertEquals((Object)"0\\..*", (Object)tool.getVersionMatchRegExpr());
    }

    @Test
    public void verifyThatConfigReturnsBaseDir() throws IOException {
        Assert.assertNotNull((Object)config);
        ToolsConfig.Tool tool = (ToolsConfig.Tool)config.getTools().get("tkn");
        Assert.assertNotNull((Object)tool);
        Assert.assertEquals((Object)"$HOME/.tekton", (Object)tool.getBaseDir());
    }

    @Test
    public void verifyThatConfigReturnsPlatforms() throws IOException {
        Assert.assertNotNull((Object)config);
        ToolsConfig.Tool tool = (ToolsConfig.Tool)config.getTools().get("tkn");
        Assert.assertNotNull((Object)tool);
        Assert.assertNotNull((Object)tool.getPlatforms());
        Assert.assertFalse((boolean)tool.getPlatforms().isEmpty());
    }

    @Test
    public void verifyThatConfigReturnsWindowsPlatform() throws IOException {
        Assert.assertNotNull((Object)config);
        ToolsConfig.Tool tool = (ToolsConfig.Tool)config.getTools().get("tkn");
        Assert.assertNotNull((Object)tool);
        Assert.assertNotNull((Object)tool.getPlatforms());
        Assert.assertFalse((boolean)tool.getPlatforms().isEmpty());
        Assert.assertNotNull(tool.getPlatforms().get("win"));
    }

    @Test
    public void verifyThatConfigReturnsOSXPlatform() throws IOException {
        Assert.assertNotNull((Object)config);
        ToolsConfig.Tool tool = (ToolsConfig.Tool)config.getTools().get("tkn");
        Assert.assertNotNull((Object)tool);
        Assert.assertNotNull((Object)tool.getPlatforms());
        Assert.assertFalse((boolean)tool.getPlatforms().isEmpty());
        Assert.assertNotNull(tool.getPlatforms().get("osx"));
    }

    @Test
    public void verifyThatConfigReturnsLinuxPlatform() throws IOException {
        Assert.assertNotNull((Object)config);
        ToolsConfig.Tool tool = (ToolsConfig.Tool)config.getTools().get("tkn");
        Assert.assertNotNull((Object)tool);
        Assert.assertNotNull((Object)tool.getPlatforms());
        Assert.assertFalse((boolean)tool.getPlatforms().isEmpty());
        Assert.assertNotNull(tool.getPlatforms().get("lnx"));
    }
}

