/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.redhat.devtools.intellij.common.BaseTest;
import com.redhat.devtools.intellij.common.utils.VirtualFileHelper;
import com.redhat.devtools.intellij.common.utils.YAMLHelper;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class VirtualFileHelperTest
extends BaseTest {
    private static final String RESOURCE_PATH = "utils/virtualFileHelper/";

    @Test
    public void CleanContent_ContentIsEmpty_OriginalContent() {
        String result = VirtualFileHelper.cleanContent((String)"");
        Assert.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void CleanContent_ContentHasNoMetadata_OriginalContent() throws IOException {
        String content = this.load("utils/virtualFileHelper/pipeline_without_metadata.yaml");
        String result = VirtualFileHelper.cleanContent((String)content);
        Assert.assertEquals((Object)content, (Object)result);
    }

    @Test
    public void CleanContent_ContentHasMetadataWithoutClutterTags_OriginalContent() throws IOException {
        String content = this.load("utils/virtualFileHelper/pipeline_with_no_clutters.yaml");
        JsonNode content_Node = YAMLHelper.YAMLToJsonNode((String)content);
        String result = VirtualFileHelper.cleanContent((String)content);
        JsonNode result_Node = YAMLHelper.YAMLToJsonNode((String)result);
        Assert.assertEquals((Object)content_Node.get("metadata"), (Object)result_Node.get("metadata"));
        Assert.assertEquals((Object)content_Node.get("spec"), (Object)result_Node.get("spec"));
    }

    @Test
    public void CleanContent_ContentHasMetadataWithoutClutterTags_CleanedContent() throws IOException {
        String content = this.load("utils/virtualFileHelper/pipeline_with_clutters.yaml");
        String content_without_clutters = this.load("utils/virtualFileHelper/pipeline_with_no_clutters.yaml");
        JsonNode content_without_clutters_Node = YAMLHelper.YAMLToJsonNode((String)content_without_clutters);
        String result = VirtualFileHelper.cleanContent((String)content);
        JsonNode result_Node = YAMLHelper.YAMLToJsonNode((String)result);
        Assert.assertEquals((Object)content_without_clutters_Node.get("metadata"), (Object)result_Node.get("metadata"));
        Assert.assertEquals((Object)content_without_clutters_Node.get("spec"), (Object)result_Node.get("spec"));
    }
}

