/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.actions.editor;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.testFramework.LightVirtualFile;
import com.redhat.devtools.intellij.common.CommonConstants;
import com.redhat.devtools.intellij.common.actions.editor.ActionTest;
import com.redhat.devtools.intellij.common.actions.editor.RemoveYAMLClutterActionHandler;
import com.redhat.devtools.intellij.common.utils.VirtualFileHelper;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class RemoveYAMLClutterActionHandlerTest
extends ActionTest {
    private static final String RESOURCE_PATH = "actions/removeYAMLClutterActionHandler/";

    @Test
    public void ExecuteWriteAction_FileIsTekton_EditorTextIsUpdated() {
        this.ExecuteWriteAction("content", "content", "content");
    }

    @Test
    public void ExecuteWriteAction_FileIsTektonAndHasNoClutters_EditorTextIsUpdatedWithSameContent() throws IOException {
        String content_with_clutters = this.load("actions/removeYAMLClutterActionHandler/pipeline_with_clutters.yaml");
        String content = this.load("actions/removeYAMLClutterActionHandler/pipeline_with_no_clutters.yaml");
        this.ExecuteWriteAction(content_with_clutters, content, content);
    }

    @Test
    public void ExecuteWriteAction_FileIsTektonAndHasClutter_EditorTextIsUpdatedWithCleanedContent() throws IOException {
        String content_with_clutters = this.load("actions/removeYAMLClutterActionHandler/pipeline_with_clutters.yaml");
        String content = this.load("actions/removeYAMLClutterActionHandler/pipeline_with_no_clutters.yaml");
        this.ExecuteWriteAction(content_with_clutters, content_with_clutters, content);
    }

    private void ExecuteWriteAction(String originalContent, String contentDisplayedInEditor, String cleanedContent) {
        RemoveYAMLClutterActionHandler removeYAMLClutterActionHandler = new RemoveYAMLClutterActionHandler();
        LightVirtualFile vf = new LightVirtualFile("name", (CharSequence)contentDisplayedInEditor);
        vf.putUserData(CommonConstants.CONTENT, (Object)originalContent);
        FileDocumentManager fileDocumentManager = (FileDocumentManager)Mockito.mock(FileDocumentManager.class);
        Mockito.when((Object)fileDocumentManager.getFile((Document)ArgumentMatchers.any())).thenReturn((Object)vf);
        try (MockedStatic fileDocumentManagerMockedStatic = Mockito.mockStatic(FileDocumentManager.class);
             MockedStatic virtualFileHelperMockedStatic = Mockito.mockStatic(VirtualFileHelper.class);){
            virtualFileHelperMockedStatic.when(() -> VirtualFileHelper.cleanContent((String)ArgumentMatchers.anyString())).thenReturn((Object)cleanedContent);
            fileDocumentManagerMockedStatic.when(FileDocumentManager::getInstance).thenReturn((Object)fileDocumentManager);
            removeYAMLClutterActionHandler.executeWriteAction(this.editor, null, this.dataContext);
            ((Document)Mockito.verify((Object)this.document, (VerificationMode)Mockito.times((int)1))).setText((CharSequence)cleanedContent);
        }
    }

    @Test
    public void ExecuteWriteAction_FileIsNotTekton_EditorTextIsNotUpdated() {
        RemoveYAMLClutterActionHandler removeYAMLClutterActionHandler = new RemoveYAMLClutterActionHandler();
        LightVirtualFile vf = new LightVirtualFile("name", (CharSequence)"content");
        FileDocumentManager fileDocumentManager = (FileDocumentManager)Mockito.mock(FileDocumentManager.class);
        Mockito.when((Object)fileDocumentManager.getFile((Document)ArgumentMatchers.any())).thenReturn((Object)vf);
        try (MockedStatic fileDocumentManagerMockedStatic = Mockito.mockStatic(FileDocumentManager.class);){
            fileDocumentManagerMockedStatic.when(FileDocumentManager::getInstance).thenReturn((Object)fileDocumentManager);
            removeYAMLClutterActionHandler.executeWriteAction(this.editor, null, this.dataContext);
            ((Document)Mockito.verify((Object)this.document, (VerificationMode)Mockito.times((int)0))).setText((CharSequence)ArgumentMatchers.anyString());
        }
    }

    @Test
    public void GetUpdatedContent_CallCleanContentMethod() {
        RemoveYAMLClutterActionHandler removeYAMLClutterActionHandler = new RemoveYAMLClutterActionHandler();
        try (MockedStatic virtualFileHelperMockedStatic = Mockito.mockStatic(VirtualFileHelper.class);){
            virtualFileHelperMockedStatic.when(() -> VirtualFileHelper.cleanContent((String)ArgumentMatchers.anyString())).thenReturn((Object)"");
            removeYAMLClutterActionHandler.getUpdatedContent("", "");
            virtualFileHelperMockedStatic.verify(Mockito.times((int)1), () -> VirtualFileHelper.cleanContent((String)ArgumentMatchers.anyString()));
        }
    }

    @Test
    public void IsCleaned_True() {
        RemoveYAMLClutterActionHandler removeYAMLClutterActionHandler = new RemoveYAMLClutterActionHandler();
        Assert.assertTrue((boolean)removeYAMLClutterActionHandler.isCleaned());
    }
}

