/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.ui.treeStructure.Tree;
import java.awt.Component;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreeAction
extends AnAction {
    private Class[] filters;
    private boolean acceptMultipleItems;

    public TreeAction(Class ... filters) {
        this.acceptMultipleItems = false;
        this.filters = filters;
    }

    public TreeAction(boolean acceptMultipleItems, Class ... filters) {
        this.acceptMultipleItems = acceptMultipleItems;
        this.filters = filters;
    }

    @Nullable
    protected Tree getTree(AnActionEvent e) {
        Component component = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        if (component instanceof Tree) {
            return (Tree)component;
        }
        return null;
    }

    protected Object getSelected(Tree tree) {
        return tree.getSelectionModel().getSelectionPath().getLastPathComponent();
    }

    protected Object[] getSelectedNodes(Tree tree) {
        TreePath[] treePaths = tree.getSelectionModel().getSelectionPaths();
        return Arrays.stream(treePaths).map(path -> path.getLastPathComponent()).toArray(Object[]::new);
    }

    protected Object adjust(Object selected) {
        return selected;
    }

    public void update(AnActionEvent e) {
        boolean visible = false;
        boolean enabled = false;
        Tree comp = this.getTree(e);
        if (comp != null) {
            Object[] selected = this.getSelectedNodes(comp);
            visible = this.isVisible(selected);
            enabled = this.isEnabled(selected);
        }
        e.getPresentation().setVisible(visible);
        if (visible) {
            e.getPresentation().setEnabled(enabled);
        }
    }

    public boolean isEnabled(Object selected) {
        return true;
    }

    public boolean isEnabled(Object[] selected) {
        for (Object item : selected) {
            Object adjusted = this.adjust(item);
            if (adjusted != null && this.isEnabled(adjusted)) continue;
            return false;
        }
        return true;
    }

    public boolean isVisible(Object selected) {
        return Stream.of(this.filters).anyMatch(cl -> cl.isAssignableFrom(selected.getClass()));
    }

    public boolean isVisible(Object[] selected) {
        if (!this.acceptMultipleItems && selected.length > 1) {
            return false;
        }
        for (Object item : selected) {
            Object adjusted = this.adjust(item);
            if (adjusted != null && this.isVisible(adjusted)) continue;
            return false;
        }
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
        Tree tree;
        if (anActionEvent == null) {
            TreeAction.$$$reportNull$$$0(0);
        }
        if ((tree = this.getTree(anActionEvent)) != null) {
            TreePath[] selectedPaths = tree.getSelectionModel().getSelectionPaths();
            Object[] selected = this.getSelectedNodes(tree);
            this.actionPerformed(anActionEvent, selectedPaths, selected);
        }
    }

    public abstract void actionPerformed(AnActionEvent var1, TreePath var2, Object var3);

    public void actionPerformed(AnActionEvent anActionEvent, TreePath[] path, Object[] selected) {
        if (selected.length == 0 || path.length == 0) {
            this.actionPerformed(anActionEvent, (TreePath)null, null);
        } else {
            this.actionPerformed(anActionEvent, path[0], selected[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anActionEvent", "com/redhat/devtools/intellij/common/actions/TreeAction", "actionPerformed"));
    }
}

