/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.actions.editor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.devtools.intellij.common.CommonConstants;
import com.redhat.devtools.intellij.common.actions.editor.YAMLClutterActionHandler;
import com.redhat.devtools.intellij.common.utils.YAMLHelper;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreYAMLClutterActionHandler
extends YAMLClutterActionHandler {
    private static final Logger logger = LoggerFactory.getLogger(RestoreYAMLClutterActionHandler.class);

    @Override
    public String getUpdatedContent(String originalContent, String currentContent) {
        return this.restoreYAMLClutter(originalContent, currentContent);
    }

    @Override
    public boolean isCleaned() {
        return false;
    }

    private String restoreYAMLClutter(String originalContent, String currentContent) {
        if (originalContent.isEmpty()) {
            return currentContent;
        }
        try {
            ObjectNode currentContentMetadata;
            JsonNode originalContentNode = YAMLHelper.YAMLToJsonNode(originalContent);
            ObjectNode currentContentNode = (ObjectNode)YAMLHelper.YAMLToJsonNode(currentContent);
            ObjectNode originalContentMetadata = originalContentNode.has("metadata") ? (ObjectNode)originalContentNode.get("metadata") : null;
            ObjectNode objectNode = currentContentMetadata = currentContentNode.has("metadata") ? (ObjectNode)currentContentNode.get("metadata") : null;
            if (currentContentMetadata == null) {
                currentContentNode.set("metadata", (JsonNode)originalContentMetadata);
            } else {
                this.setMetadataFieldsValues(CommonConstants.metadataClutter, (JsonNode)originalContentMetadata, currentContentMetadata);
                currentContentNode.set("metadata", (JsonNode)currentContentMetadata);
            }
            currentContent = YAMLHelper.JSONToYAML((JsonNode)currentContentNode);
        }
        catch (IOException e) {
            logger.warn(e.getLocalizedMessage(), (Throwable)e);
        }
        return currentContent;
    }

    private void setMetadataFieldsValues(List<String> fields, JsonNode originalContentMetadata, ObjectNode currentContentMetadata) {
        fields.forEach(field -> {
            if (originalContentMetadata.has(field)) {
                currentContentMetadata.set(field, originalContentMetadata.get(field));
            }
        });
    }
}

