/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.actions.editor;

import com.google.common.base.Strings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.redhat.devtools.intellij.common.CommonConstants;
import com.redhat.devtools.intellij.common.actions.editor.RestoreYAMLClutterActionHandler;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class YAMLClutterActionHandler
extends EditorWriteActionHandler {
    private static final Logger logger = LoggerFactory.getLogger(RestoreYAMLClutterActionHandler.class);

    public void executeWriteAction(Editor editor, @Nullable Caret caret, DataContext dataContext) {
        VirtualFile vf = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (!Strings.isNullOrEmpty((String)((String)vf.getUserData(CommonConstants.CONTENT)))) {
            editor.getDocument().setText((CharSequence)this.getUpdatedContent((String)vf.getUserData(CommonConstants.CONTENT), editor.getDocument().getText()));
            vf.putUserData(CommonConstants.CLEANED, (Object)this.isCleaned());
        }
    }

    public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        if (editor == null) {
            YAMLClutterActionHandler.$$$reportNull$$$0(0);
        }
        VirtualFile vf = FileDocumentManager.getInstance().getFile(editor.getDocument());
        boolean isWritable = vf.isWritable();
        try {
            editor.getDocument().setReadOnly(false);
            vf.setWritable(true);
            super.doExecute(editor, caret, dataContext);
            vf.setWritable(isWritable);
            editor.getDocument().setReadOnly(!isWritable);
        }
        catch (IOException e) {
            logger.warn(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public abstract String getUpdatedContent(String var1, String var2);

    public abstract boolean isCleaned();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/redhat/devtools/intellij/common/actions/editor/YAMLClutterActionHandler", "doExecute"));
    }
}

