/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.kubernetes;

import com.redhat.devtools.intellij.common.kubernetes.ClusterInfo;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.VersionInfo;
import io.fabric8.openshift.client.OpenShiftClient;

public class ClusterHelper {
    public static ClusterInfo getClusterInfo(KubernetesClient client) {
        if (client instanceof OpenShiftClient) {
            return new ClusterInfo(ClusterHelper.getKubernetesVersion((OpenShiftClient)client), true, ClusterHelper.getOpenShiftVersion((OpenShiftClient)client));
        }
        if (Boolean.TRUE.equals(client.isAdaptable(OpenShiftClient.class))) {
            return new ClusterInfo(ClusterHelper.getKubernetesVersion(client), true, ClusterHelper.getOpenShiftVersion(client));
        }
        return new ClusterInfo(ClusterHelper.getKubernetesVersion(client), false, "");
    }

    private static String getKubernetesVersion(OpenShiftClient client) {
        String string;
        DefaultKubernetesClient kclient = new DefaultKubernetesClient(client.getConfiguration());
        try {
            string = ClusterHelper.getKubernetesVersion((KubernetesClient)kclient);
        }
        catch (Throwable throwable) {
            try {
                try {
                    kclient.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (KubernetesClientException e) {
                return null;
            }
        }
        kclient.close();
        return string;
    }

    private static String getKubernetesVersion(KubernetesClient client) {
        VersionInfo version = client.getVersion();
        return version != null ? version.getGitVersion() : "";
    }

    private static String getOpenShiftVersion(KubernetesClient client) {
        String string;
        block8: {
            OpenShiftClient oclient = (OpenShiftClient)client.adapt(OpenShiftClient.class);
            try {
                string = ClusterHelper.getOpenShiftVersion(oclient);
                if (oclient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (oclient != null) {
                        try {
                            oclient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (KubernetesClientException e) {
                    return null;
                }
            }
            oclient.close();
        }
        return string;
    }

    private static String getOpenShiftVersion(OpenShiftClient client) {
        VersionInfo version = client.getVersion();
        return version != null && version.getMajor() != null ? ClusterHelper.getVersion(version.getMajor(), version.getMinor()) : "";
    }

    private static String getVersion(String major, String minor) {
        return major + '.' + minor;
    }
}

