/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import java.time.Duration;
import java.time.Instant;

public class DateHelper {
    public static String humanizeDate(Instant start) {
        return DateHelper.humanizeDate(start, Instant.now());
    }

    public static String humanizeDate(Instant start, Instant end) {
        long seconds = Duration.between(start, end).getSeconds();
        int days = (int)(seconds / 86400L);
        int hours = (int)((seconds %= 86400L) / 3600L);
        int minutes = (int)((seconds %= 3600L) / 60L);
        if ((seconds %= 60L) < 0L) {
            seconds = 0L;
        }
        String date = "";
        if (days > 0) {
            date = date + days + " d ";
        }
        if (date.length() < 6 && (hours > 0 || days > 0)) {
            date = date + hours + " h ";
        }
        if (date.length() < 6 && (minutes > 0 || hours > 0)) {
            date = date + minutes + " m ";
        }
        if (date.length() < 6) {
            date = date + seconds + " s ";
        }
        return date;
    }
}

