/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.TerminalExecutionConsole;
import com.pty4j.PtyProcess;
import com.pty4j.PtyProcessBuilder;
import com.redhat.devtools.intellij.common.CommonConstants;
import com.redhat.devtools.intellij.common.utils.ExecProcessHandler;
import com.redhat.devtools.intellij.common.utils.ExecRunContentDescriptor;
import com.redhat.devtools.intellij.common.utils.UIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.output.WriterOutputStream;
import org.jetbrains.annotations.Nullable;

public class ExecHelper {
    private static final ScheduledExecutorService SERVICE = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());

    private ExecHelper() {
    }

    public static ScheduledFuture<?> executeAfter(Runnable runnable, long delay, TimeUnit unit) {
        return SERVICE.schedule(runnable, delay, unit);
    }

    public static void submit(Runnable runnable) {
        SERVICE.submit(runnable);
    }

    public static String execute(String executable, final boolean checkExitCode, File workingDirectory, Map<String, String> envs, String ... arguments) throws IOException {
        DefaultExecutor executor = new DefaultExecutor(){

            public boolean isFailure(int exitValue) {
                if (checkExitCode) {
                    return super.isFailure(exitValue);
                }
                return false;
            }
        };
        StringWriter writer = new StringWriter();
        PumpStreamHandler handler = new PumpStreamHandler((OutputStream)new WriterOutputStream((Writer)writer, Charset.defaultCharset()));
        executor.setStreamHandler((ExecuteStreamHandler)handler);
        executor.setWorkingDirectory(workingDirectory);
        CommandLine command = new CommandLine(executable).addArguments(arguments, false);
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        env.putAll(envs);
        try {
            executor.execute(command, env);
            return writer.toString();
        }
        catch (IOException e) {
            throw new IOException(e.getLocalizedMessage() + " " + writer.toString(), e);
        }
    }

    public static String execute(String executable, File workingDirectory, Map<String, String> envs, String ... arguments) throws IOException {
        return ExecHelper.execute(executable, true, workingDirectory, envs, arguments);
    }

    public static String execute(String executable, Map<String, String> envs, String ... arguments) throws IOException {
        return ExecHelper.execute(executable, true, new File(CommonConstants.HOME_FOLDER), envs, arguments);
    }

    public static String execute(String executable, String ... arguments) throws IOException {
        return ExecHelper.execute(executable, Collections.emptyMap(), arguments);
    }

    public static String execute(String executable, File workingDirectory, String ... arguments) throws IOException {
        return ExecHelper.execute(executable, true, workingDirectory, Collections.emptyMap(), arguments);
    }

    public static String execute(String executable, boolean checkExitCode, Map<String, String> envs, String ... arguments) throws IOException {
        return ExecHelper.execute(executable, checkExitCode, new File(CommonConstants.HOME_FOLDER), envs, arguments);
    }

    public static String execute(String executable, boolean checkExitCode, String ... arguments) throws IOException {
        return ExecHelper.execute(executable, checkExitCode, new File(CommonConstants.HOME_FOLDER), Collections.emptyMap(), arguments);
    }

    public static ExecResult executeWithResult(String executable, final boolean checkExitCode, File workingDirectory, Map<String, String> envs, String ... arguments) throws IOException {
        DefaultExecutor executor = new DefaultExecutor(){

            public boolean isFailure(int exitValue) {
                if (checkExitCode) {
                    return super.isFailure(exitValue);
                }
                return false;
            }
        };
        StringWriter outWriter = new StringWriter();
        StringWriter errWriter = new StringWriter();
        PumpStreamHandler handler = new PumpStreamHandler((OutputStream)new WriterOutputStream((Writer)outWriter, Charset.defaultCharset()), (OutputStream)new WriterOutputStream((Writer)errWriter, Charset.defaultCharset()));
        executor.setStreamHandler((ExecuteStreamHandler)handler);
        executor.setWorkingDirectory(workingDirectory);
        CommandLine command = new CommandLine(executable).addArguments(arguments, false);
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        env.putAll(envs);
        try {
            int exitCode = executor.execute(command, env);
            return new ExecResult(outWriter.toString(), errWriter.toString(), exitCode);
        }
        catch (IOException e) {
            throw new IOException(e.getLocalizedMessage() + " " + errWriter.toString(), e);
        }
    }

    public static ExecResult executeWithResult(String executable, Map<String, String> envs, String ... arguments) throws IOException {
        return ExecHelper.executeWithResult(executable, true, new File(CommonConstants.HOME_FOLDER), envs, arguments);
    }

    private static void executeWithTerminalInternal(Project project, String title, File workingDirectory, boolean waitForProcessExit, Map<String, String> envs, String ... command) throws IOException {
        PtyProcessBuilder builder = new PtyProcessBuilder(command);
        builder.setEnvironment(ExecHelper.getEnvs(envs));
        builder.setDirectory(workingDirectory.getPath());
        builder.setRedirectErrorStream(true);
        PtyProcess p = builder.start();
        ExecHelper.linkProcessToTerminal(p, project, title, waitForProcessExit, command);
    }

    private static Map<String, String> getEnvs(Map<String, String> customEnvs) {
        HashMap<String, String> envs = new HashMap<String, String>();
        envs.putAll(System.getenv());
        envs.putAll(customEnvs);
        return envs;
    }

    public static void linkProcessToTerminal(PtyProcess p, Project project, String title, boolean waitForProcessExit, String ... command) throws IOException {
        ExecProcessHandler processHandler = new ExecProcessHandler((Process)p, String.join((CharSequence)" ", command), Charset.defaultCharset());
        TerminalExecutionConsole terminalExecutionConsole = new TerminalExecutionConsole(project, (ProcessHandler)processHandler);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)terminalExecutionConsole.getComponent(), "Center");
        processHandler.startNotify();
        String tabTitle = ExecHelper.getTabTitle(project, title);
        ApplicationManager.getApplication().invokeLater(() -> {
            ExecRunContentDescriptor contentDescriptor = new ExecRunContentDescriptor((ExecutionConsole)terminalExecutionConsole, (ProcessHandler)processHandler, panel, tabTitle);
            RunContentManager.getInstance((Project)project).showRunContent(DefaultRunExecutor.getRunExecutorInstance(), (RunContentDescriptor)contentDescriptor);
        });
        try {
            if (waitForProcessExit && p.waitFor() != 0) {
                throw new IOException("Process returned exit code: " + p.exitValue(), null);
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private static String getTabTitle(Project project, String title) {
        Pattern pattern = Pattern.compile(title + "\\(([0-9]+)\\)");
        int max = RunContentManager.getInstance((Project)project).getAllDescriptors().stream().mapToInt(run -> {
            Matcher m = pattern.matcher(run.getDisplayName());
            if (m.find()) {
                return Integer.parseInt(m.group(1));
            }
            return -1;
        }).max().orElse(0);
        return title + "(" + ++max + ")";
    }

    public static void executeWithTerminal(Project project, String title, File workingDirectory, boolean waitForProcessToExit, Map<String, String> envs, String ... command) throws IOException {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ExecHelper.execute(command[0], workingDirectory, envs, (String[])Arrays.stream(command).skip(1L).toArray(String[]::new));
        } else {
            ExecHelper.executeWithTerminalInternal(project, title, workingDirectory, waitForProcessToExit, envs, command);
        }
    }

    public static void executeWithTerminal(Project project, String title, File workingDirectory, String ... command) throws IOException {
        ExecHelper.executeWithTerminal(project, title, workingDirectory, true, Collections.emptyMap(), command);
    }

    public static void executeWithTerminal(Project project, String title, boolean waitForProcessToExit, Map<String, String> envs, String ... command) throws IOException {
        ExecHelper.executeWithTerminal(project, title, new File(CommonConstants.HOME_FOLDER), waitForProcessToExit, envs, command);
    }

    public static void executeWithTerminal(Project project, String title, boolean waitForProcessToExit, String ... command) throws IOException {
        ExecHelper.executeWithTerminal(project, title, new File(CommonConstants.HOME_FOLDER), waitForProcessToExit, Collections.emptyMap(), command);
    }

    public static void executeWithTerminal(Project project, String title, Map<String, String> envs, String ... command) throws IOException {
        ExecHelper.executeWithTerminal(project, title, new File(CommonConstants.HOME_FOLDER), true, envs, command);
    }

    public static void executeWithTerminal(Project project, String title, String ... command) throws IOException {
        ExecHelper.executeWithTerminal(project, title, new File(CommonConstants.HOME_FOLDER), true, Collections.emptyMap(), command);
    }

    public static void executeWithUI(Map<String, String> envs, Runnable initRunnable, Consumer<String> runnable, String ... command) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(command).directory(new File(CommonConstants.HOME_FOLDER)).redirectErrorStream(true);
        builder.environment().putAll(envs);
        Process p = builder.start();
        ExecHelper.linkProcessToUI(p, initRunnable, runnable);
    }

    public static void executeWithUI(Map<String, String> envs, Consumer<String> runnable, String ... command) throws IOException {
        ExecHelper.executeWithUI(envs, null, runnable, command);
    }

    private static void linkProcessToUI(Process p, Runnable initRunnable, Consumer<String> runnable) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (initRunnable != null) {
                UIHelper.executeInUI(initRunnable);
            }
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8));
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                    UIHelper.executeInUI(() -> runnable.accept(sb.toString()));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    public static class ExecResult {
        private final String stdOut;
        @Nullable
        private final String stdErr;
        private final int exitCode;

        public ExecResult(String stdOut, @Nullable String stdErr, int exitCode) {
            this.stdOut = stdOut;
            this.stdErr = stdErr;
            this.exitCode = exitCode;
        }

        public String getStdOut() {
            return this.stdOut;
        }

        public String getStdErr() {
            return this.stdErr;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

