/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.openapi.application.ApplicationManager;
import java.util.function.Supplier;
import javax.swing.UIManager;

public class UIHelper {
    public static void executeInUI(Runnable runnable) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().invokeAndWait(runnable);
        }
    }

    public static <T> T executeInUI(Supplier<T> supplier) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return supplier.get();
        }
        Object[] val = new Object[1];
        ApplicationManager.getApplication().invokeAndWait(() -> {
            val[0] = supplier.get();
        });
        return (T)val[0];
    }

    public static boolean isDarkMode() {
        UIManager.LookAndFeelInfo lafInfo = LafManager.getInstance().getCurrentLookAndFeel();
        return lafInfo != null && lafInfo.getClassName().equals(DarculaLaf.class.getName());
    }
}

