/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.listener;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.ui.DoubleClickListener;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public abstract class TreeDoubleClickListener
extends DoubleClickListener {
    private final JTree tree;

    public TreeDoubleClickListener(JTree tree) {
        this.tree = tree;
        this.installOn(tree);
    }

    protected boolean onDoubleClick(MouseEvent event) {
        TreePath clickPath = this.tree.getPathForLocation(event.getX(), event.getY());
        if (clickPath == null) {
            return false;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.tree);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        TreePath selectionPath = this.tree.getSelectionPath();
        if (!clickPath.equals(selectionPath)) {
            return false;
        }
        if (event.getClickCount() == 2) {
            this.processDoubleClick(selectionPath);
            return true;
        }
        return false;
    }

    protected abstract void processDoubleClick(@NotNull TreePath var1);
}

