/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.terminal.AppendableTerminalDataStream;
import com.intellij.terminal.JBTerminalPanel;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.ProcessHandlerTtyConnector;
import com.intellij.util.LineSeparator;
import com.jediterm.terminal.HyperlinkStyle;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalDataStream;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.JediTerminal;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import com.pty4j.PtyProcess;
import com.redhat.devtools.intellij.common.utils.ExecRunContentDescriptor;
import java.awt.Color;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonTerminalExecutionConsole
implements ConsoleView,
ObservableConsoleView {
    private static final Logger LOG = Logger.getInstance(CommonTerminalExecutionConsole.class);
    private JBTerminalWidget myTerminalWidget;
    private final Project myProject;
    private final String tabTitle;
    private final AppendableTerminalDataStream myDataStream;
    private final AtomicBoolean myAttachedToProcess;
    private volatile boolean myLastCR;
    private ProcessHandler processHandler;
    private ProcessAdapter processAdapter;
    private boolean contentToBeStarted;
    private static final int ESC = 27;
    private boolean myEnterKeyDefaultCodeEnabled;

    public CommonTerminalExecutionConsole(@NotNull Project project, @Nullable ProcessHandler processHandler, String tabTitle) {
        if (project == null) {
            CommonTerminalExecutionConsole.$$$reportNull$$$0(0);
        }
        this.myAttachedToProcess = new AtomicBoolean(false);
        this.myLastCR = false;
        this.contentToBeStarted = false;
        this.myEnterKeyDefaultCodeEnabled = true;
        this.myProject = project;
        this.tabTitle = tabTitle;
        JBTerminalSystemSettingsProviderBase provider = new JBTerminalSystemSettingsProviderBase(){

            public HyperlinkStyle.HighlightMode getHyperlinkHighlightingMode() {
                return HyperlinkStyle.HighlightMode.ALWAYS;
            }
        };
        this.myDataStream = new AppendableTerminalDataStream();
        this.myTerminalWidget = new ConsoleTerminalWidget(project, provider);
        if (processHandler != null) {
            this.attachToProcess(processHandler);
        }
    }

    private void printText(@NotNull String text, @Nullable ConsoleViewContentType contentType) throws IOException {
        Color foregroundColor;
        if (text == null) {
            CommonTerminalExecutionConsole.$$$reportNull$$$0(1);
        }
        Color color = foregroundColor = contentType != null ? contentType.getAttributes().getForegroundColor() : null;
        if (foregroundColor != null) {
            this.myDataStream.append((CharSequence)CommonTerminalExecutionConsole.encodeColor(foregroundColor));
        }
        this.myDataStream.append((CharSequence)text);
        if (foregroundColor != null) {
            this.myDataStream.append((CharSequence)"\u001b[39m");
        }
    }

    @NotNull
    private static String encodeColor(@NotNull Color color) {
        if (color == null) {
            CommonTerminalExecutionConsole.$$$reportNull$$$0(2);
        }
        String string = "\u001b[38;2;" + color.getRed() + ";" + color.getGreen() + ";" + color.getBlue() + "m";
        if (string == null) {
            CommonTerminalExecutionConsole.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Deprecated
    public void setAutoNewLineMode(boolean enabled) {
    }

    @NotNull
    public CommonTerminalExecutionConsole withEnterKeyDefaultCodeEnabled(boolean enterKeyDefaultCodeEnabled) {
        this.myEnterKeyDefaultCodeEnabled = enterKeyDefaultCodeEnabled;
        CommonTerminalExecutionConsole commonTerminalExecutionConsole = this;
        if (commonTerminalExecutionConsole == null) {
            CommonTerminalExecutionConsole.$$$reportNull$$$0(4);
        }
        return commonTerminalExecutionConsole;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public void addMessageFilter(Project project, Filter filter) {
        this.myTerminalWidget.addMessageFilter(filter);
    }

    public void print(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        if (text == null) {
            CommonTerminalExecutionConsole.$$$reportNull$$$0(5);
        }
        if (contentType == null) {
            CommonTerminalExecutionConsole.$$$reportNull$$$0(6);
        }
        String textCRLF = this.convertTextToCRLF(text);
        try {
            this.printText(textCRLF, contentType);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    @NotNull
    private String convertTextToCRLF(@NotNull String text) {
        boolean preserveLastCR;
        if (text == null) {
            CommonTerminalExecutionConsole.$$$reportNull$$$0(7);
        }
        if (text.isEmpty()) {
            String string = text;
            if (string == null) {
                CommonTerminalExecutionConsole.$$$reportNull$$$0(8);
            }
            return string;
        }
        boolean preserveFirstLF = text.startsWith(LineSeparator.LF.getSeparatorString()) && this.myLastCR;
        this.myLastCR = preserveLastCR = text.endsWith(LineSeparator.CR.getSeparatorString());
        String textToConvert = text.substring(preserveFirstLF ? 1 : 0, preserveLastCR ? text.length() - 1 : text.length());
        String textCRLF = StringUtil.convertLineSeparators((String)textToConvert, (String)LineSeparator.CRLF.getSeparatorString());
        if (preserveFirstLF) {
            textCRLF = LineSeparator.LF.getSeparatorString() + textCRLF;
        }
        if (preserveLastCR) {
            textCRLF = textCRLF + LineSeparator.CR.getSeparatorString();
        }
        String string = textCRLF;
        if (string == null) {
            CommonTerminalExecutionConsole.$$$reportNull$$$0(9);
        }
        return string;
    }

    public void clear() {
        this.myLastCR = false;
        this.myTerminalWidget.getTerminalPanel().clearBuffer();
    }

    public void scrollTo(int offset) {
    }

    public void attachToProcess(ProcessHandler processHandler) {
        if (processHandler != null) {
            this.attachToProcess(processHandler, true);
        }
    }

    protected final void attachToProcess(@NotNull ProcessHandler processHandler, final boolean attachToProcessOutput) {
        if (processHandler == null) {
            CommonTerminalExecutionConsole.$$$reportNull$$$0(10);
        }
        if (this.myAttachedToProcess.compareAndSet(false, true)) {
            this.myTerminalWidget.createTerminalSession((TtyConnector)new ProcessHandlerTtyConnector(processHandler, EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset()));
            this.myTerminalWidget.start();
            this.contentToBeStarted = true;
        } else {
            this.myTerminalWidget.setTtyConnector((TtyConnector)new ProcessHandlerTtyConnector(processHandler, EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset()));
        }
        this.updateProcessHandler(processHandler);
        this.processAdapter = new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (attachToProcessOutput) {
                    try {
                        ConsoleViewContentType contentType = null;
                        if (outputType != ProcessOutputTypes.STDOUT) {
                            contentType = ConsoleViewContentType.getConsoleViewType((Key)outputType);
                        }
                        String text = event.getText();
                        if (outputType == ProcessOutputTypes.SYSTEM) {
                            text = StringUtil.convertLineSeparators((String)text, (String)LineSeparator.CRLF.getSeparatorString());
                        }
                        CommonTerminalExecutionConsole.this.printText(text, contentType);
                    }
                    catch (IOException e) {
                        LOG.info((Throwable)e);
                    }
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    JBTerminalWidget widget = CommonTerminalExecutionConsole.this.myTerminalWidget;
                    if (widget != null) {
                        widget.getTerminalPanel().setCursorVisible(false);
                    }
                }, ModalityState.any());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/redhat/devtools/intellij/common/utils/CommonTerminalExecutionConsole$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        processHandler.addProcessListener((ProcessListener)this.processAdapter);
        if (this.contentToBeStarted) {
            ApplicationManager.getApplication().invokeLater(() -> {
                ExecRunContentDescriptor contentDescriptor = new ExecRunContentDescriptor((ExecutionConsole)this, processHandler, this.getComponent(), this.tabTitle);
                RunContentManager.getInstance((Project)this.myProject).showRunContent(DefaultRunExecutor.getRunExecutorInstance(), (RunContentDescriptor)contentDescriptor);
            });
        }
    }

    private void updateProcessHandler(ProcessHandler processHandler) {
        if (this.processHandler != null) {
            this.processHandler.removeProcessListener((ProcessListener)this.processAdapter);
        }
        this.processHandler = processHandler;
    }

    public void setOutputPaused(boolean value) {
    }

    public boolean isOutputPaused() {
        return false;
    }

    public boolean hasDeferredOutput() {
        return false;
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable) {
        if (runnable == null) {
            CommonTerminalExecutionConsole.$$$reportNull$$$0(11);
        }
    }

    public void setHelpId(@NotNull String helpId) {
        if (helpId == null) {
            CommonTerminalExecutionConsole.$$$reportNull$$$0(12);
        }
    }

    public void addMessageFilter(@NotNull Filter filter) {
        if (filter == null) {
            CommonTerminalExecutionConsole.$$$reportNull$$$0(13);
        }
        this.myTerminalWidget.addMessageFilter(filter);
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
        if (hyperlinkText == null) {
            CommonTerminalExecutionConsole.$$$reportNull$$$0(14);
        }
    }

    public int getContentSize() {
        return 0;
    }

    public boolean canPause() {
        return false;
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public AnAction[] detachConsoleActions(boolean prependSeparatorIfNonEmpty) {
        if (AnAction.EMPTY_ARRAY == null) {
            CommonTerminalExecutionConsole.$$$reportNull$$$0(15);
        }
        return AnAction.EMPTY_ARRAY;
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        AnAction[] anActionArray = new AnAction[]{new ScrollToTheEndAction(), new ClearAction()};
        if (anActionArray == null) {
            CommonTerminalExecutionConsole.$$$reportNull$$$0(16);
        }
        return anActionArray;
    }

    public void allowHeavyFilters() {
    }

    public JComponent getComponent() {
        return this.myTerminalWidget.getComponent();
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myTerminalWidget.getComponent();
    }

    public void dispose() {
        this.myTerminalWidget = null;
    }

    public static boolean isAcceptable(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            CommonTerminalExecutionConsole.$$$reportNull$$$0(17);
        }
        return processHandler instanceof OSProcessHandler && ((OSProcessHandler)processHandler).getProcess() instanceof PtyProcess && !(processHandler instanceof ColoredProcessHandler);
    }

    public void addChangeListener(@NotNull ObservableConsoleView.ChangeListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            CommonTerminalExecutionConsole.$$$reportNull$$$0(18);
        }
        if (parent == null) {
            CommonTerminalExecutionConsole.$$$reportNull$$$0(19);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/redhat/devtools/intellij/common/utils/CommonTerminalExecutionConsole";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkText";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/redhat/devtools/intellij/common/utils/CommonTerminalExecutionConsole";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "encodeColor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withEnterKeyDefaultCodeEnabled";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "convertTextToCRLF";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "detachConsoleActions";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "printText";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "encodeColor";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 15: 
            case 16: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertTextToCRLF";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "performWhenNoDeferredOutput";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setHelpId";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilter";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ScrollToTheEndAction
    extends DumbAwareAction {
        private ScrollToTheEndAction() {
            super(ActionsBundle.message((String)"action.EditorConsoleScrollToTheEnd.text", (Object[])new Object[0]), ActionsBundle.message((String)"action.EditorConsoleScrollToTheEnd.text", (Object[])new Object[0]), AllIcons.RunConfigurations.Scroll_down);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ScrollToTheEndAction.$$$reportNull$$$0(0);
            }
            BoundedRangeModel model = this.getBoundedRangeModel();
            e.getPresentation().setEnabled(model != null && model.getValue() != 0);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            BoundedRangeModel model;
            if (e == null) {
                ScrollToTheEndAction.$$$reportNull$$$0(1);
            }
            if ((model = this.getBoundedRangeModel()) != null) {
                model.setValue(0);
            }
        }

        @Nullable
        private BoundedRangeModel getBoundedRangeModel() {
            return CommonTerminalExecutionConsole.this.myTerminalWidget != null ? CommonTerminalExecutionConsole.this.myTerminalWidget.getTerminalPanel().getBoundedRangeModel() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/redhat/devtools/intellij/common/utils/CommonTerminalExecutionConsole$ScrollToTheEndAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ClearAction
    extends DumbAwareAction {
        private ClearAction() {
            super(ExecutionBundle.message((String)"clear.all.from.console.action.name", (Object[])new Object[0]), "Clear the contents of the console", AllIcons.Actions.GC);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(true);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearAction.$$$reportNull$$$0(1);
            }
            CommonTerminalExecutionConsole.this.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/redhat/devtools/intellij/common/utils/CommonTerminalExecutionConsole$ClearAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ConsoleTerminalWidget
    extends JBTerminalWidget
    implements DataProvider {
        private ConsoleTerminalWidget(@NotNull Project project, JBTerminalSystemSettingsProviderBase provider) {
            if (project == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(0);
            }
            if (provider == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(1);
            }
            super(project, provider, (Disposable)CommonTerminalExecutionConsole.this);
        }

        protected JBTerminalPanel createTerminalPanel(@NotNull SettingsProvider settingsProvider, @NotNull StyleState styleState, @NotNull TerminalTextBuffer textBuffer) {
            if (settingsProvider == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(2);
            }
            if (styleState == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(3);
            }
            if (textBuffer == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(4);
            }
            JBTerminalPanel panel = new JBTerminalPanel((JBTerminalSystemSettingsProviderBase)settingsProvider, textBuffer, styleState){

                public void clearBuffer() {
                    super.clearBuffer(false);
                }
            };
            Disposer.register((Disposable)this, (Disposable)panel);
            return panel;
        }

        protected TerminalStarter createTerminalStarter(JediTerminal terminal, TtyConnector connector) {
            try {
                try {
                    Constructor constructor = TerminalStarter.class.getConstructor(Terminal.class, TtyConnector.class, TerminalDataStream.class);
                    return (TerminalStarter)constructor.newInstance(terminal, connector, CommonTerminalExecutionConsole.this.myDataStream);
                }
                catch (NoSuchMethodException e) {
                    Constructor<?> constructor = TerminalStarter.class.getConstructors()[0];
                    return (TerminalStarter)constructor.newInstance(terminal, connector, CommonTerminalExecutionConsole.this.myDataStream, null);
                }
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                LOG.warn(e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(5);
            }
            if (LangDataKeys.CONSOLE_VIEW.is(dataId)) {
                return this;
            }
            return super.getData(dataId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settingsProvider";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "styleState";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textBuffer";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/redhat/devtools/intellij/common/utils/CommonTerminalExecutionConsole$ConsoleTerminalWidget";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createTerminalPanel";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

