/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.compat;

import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class NotificationGroupFactory {
    public static NotificationGroup create(String displayId, NotificationDisplayType type, boolean logByDefault) {
        try {
            Constructor constructor = NotificationGroup.class.getConstructor(String.class, NotificationDisplayType.class, Boolean.TYPE);
            return (NotificationGroup)constructor.newInstance(displayId, type, logByDefault);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            try {
                Class<?> managerClass = Class.forName("com.intellij.notification.NotificationGroupManager");
                Method getInstance = managerClass.getMethod("getInstance", new Class[0]);
                Object manager = getInstance.invoke(null, new Object[0]);
                if (manager == null) {
                    return null;
                }
                Method getNotificationGroup = managerClass.getMethod("getNotificationGroup", String.class);
                Object group = getNotificationGroup.invoke(manager, displayId);
                if (!(group instanceof NotificationGroup)) {
                    return null;
                }
                return (NotificationGroup)group;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                Logger.getInstance(NotificationGroupFactory.class).warn("Could not create NotificationGroup for IC-" + ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode());
                return null;
            }
        }
    }
}

