/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.redhat.devtools.intellij.common.BaseTest;
import com.redhat.devtools.intellij.common.utils.MetadataClutter;
import com.redhat.devtools.intellij.common.utils.YAMLHelper;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.ManagedFieldsEntry;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class MetadataClutterTest
extends BaseTest {
    private static final String RESOURCE_PATH = "utils/virtualFileHelper/";

    @Test
    public void remove_ContentIsEmpty_OriginalContent() {
        String result = MetadataClutter.remove((String)"");
        Assert.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void remove_ContentHasNoMetadata_OriginalContent() throws IOException {
        String content = this.load("utils/virtualFileHelper/pipeline_without_metadata.yaml");
        String result = MetadataClutter.remove((String)content);
        Assert.assertEquals((Object)content, (Object)result);
    }

    @Test
    public void remove_ContentHasMetadataWithoutClutterTags_OriginalContent() throws IOException {
        String content = this.load("utils/virtualFileHelper/pipeline_with_no_clutters.yaml");
        JsonNode content_Node = YAMLHelper.YAMLToJsonNode((String)content);
        String result = MetadataClutter.remove((String)content);
        JsonNode result_Node = YAMLHelper.YAMLToJsonNode((String)result);
        Assert.assertEquals((Object)content_Node.get("metadata"), (Object)result_Node.get("metadata"));
        Assert.assertEquals((Object)content_Node.get("spec"), (Object)result_Node.get("spec"));
    }

    @Test
    public void remove_ContentHasMetadataWithoutClutterTags_CleanedContent() throws IOException {
        String content = this.load("utils/virtualFileHelper/pipeline_with_clutters.yaml");
        String content_without_clutters = this.load("utils/virtualFileHelper/pipeline_with_no_clutters.yaml");
        JsonNode content_without_clutters_Node = YAMLHelper.YAMLToJsonNode((String)content_without_clutters);
        String result = MetadataClutter.remove((String)content, (boolean)false);
        JsonNode result_Node = YAMLHelper.YAMLToJsonNode((String)result);
        Assert.assertEquals((Object)content_without_clutters_Node.get("metadata"), (Object)result_Node.get("metadata"));
        Assert.assertEquals((Object)content_without_clutters_Node.get("spec"), (Object)result_Node.get("spec"));
    }

    @Test
    public void remove_should_return_null_if_metadata_is_null() {
        ObjectMeta mangled = MetadataClutter.remove((ObjectMeta)null);
        Assertions.assertThat((Object)mangled).isNull();
    }

    @Test
    public void remove_should_return_unchanged_metadata_if_has_no_clutter() {
        ObjectMeta metadata = ((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withName("john wayne")).withNamespace("wild west")).withLabels(Collections.singletonMap("hat", "cowboy"))).build();
        ObjectMeta mangled = MetadataClutter.remove((ObjectMeta)metadata);
        Assertions.assertThat((String)mangled.getName()).isEqualTo("john wayne");
        Assertions.assertThat((String)mangled.getNamespace()).isEqualTo("wild west");
        Assertions.assertThat((Map)mangled.getLabels()).containsAllEntriesOf(Collections.singletonMap("hat", "cowboy"));
    }

    @Test
    public void remove_should_remove_all_clutters() {
        ObjectMeta metadata = ((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withName("john wayne")).withNamespace("wild west")).withLabels(Collections.singletonMap("hat", "cowboy"))).withClusterName("B movies")).withCreationTimestamp("20th century")).withDeletionGracePeriodSeconds(Long.valueOf(42L))).withDeletionTimestamp("June 11, 1979")).withFinalizers(new String[]{"Comancheros", "Sons of Katie Elder"})).withGeneration(Long.valueOf(42L))).withManagedFields(new ManagedFieldsEntry[]{new ManagedFieldsEntry("rifle", "winchester", null, null, null, null, null)})).withOwnerReferences(new OwnerReference[]{new OwnerReference("gun", Boolean.valueOf(true), Boolean.valueOf(true), "colt", null, null)})).withResourceVersion("42")).withSelfLink("not too serious")).withUid("42")).build();
        ObjectMeta mangled = MetadataClutter.remove((ObjectMeta)metadata);
        Assertions.assertThat((String)mangled.getClusterName()).isNull();
        Assertions.assertThat((String)mangled.getCreationTimestamp()).isNull();
        Assertions.assertThat((Long)mangled.getDeletionGracePeriodSeconds()).isNull();
        Assertions.assertThat((String)mangled.getDeletionTimestamp()).isNull();
        Assertions.assertThat((List)mangled.getFinalizers()).isEmpty();
        Assertions.assertThat((Long)mangled.getGeneration()).isNull();
        Assertions.assertThat((List)mangled.getManagedFields()).isEmpty();
        Assertions.assertThat((List)mangled.getOwnerReferences()).isEmpty();
        Assertions.assertThat((String)mangled.getResourceVersion()).isNull();
        Assertions.assertThat((String)mangled.getSelfLink()).isNull();
        Assertions.assertThat((String)mangled.getUid()).isNull();
    }

    @Test
    public void remove_should_remove_same_clutter_as_remove_from_text() throws IOException {
        String withClutter = this.load("utils/virtualFileHelper/pipeline_with_clutters.yaml");
        String noClutter = MetadataClutter.remove((String)withClutter);
        GenericKubernetesResource resourceWithClutter = (GenericKubernetesResource)Serialization.unmarshal((String)withClutter, GenericKubernetesResource.class);
        ObjectMeta metaWithClutter = new ObjectMetaBuilder(resourceWithClutter.getMetadata()).build();
        ObjectMeta metaWithoutClutter = MetadataClutter.remove((ObjectMeta)metaWithClutter);
        GenericKubernetesResource noClutterResource = (GenericKubernetesResource)Serialization.unmarshal((String)noClutter);
        Assertions.assertThat((Object)metaWithoutClutter).isEqualTo((Object)noClutterResource.getMetadata());
    }

    @Test
    public void remove_ContentHasMetadataWithoutClutterTagsAndMinimizeQuotes_CleanedContent() throws IOException {
        String content = this.load("utils/virtualFileHelper/pipeline_with_clutters_2.yaml");
        String content_without_clutters = this.load("utils/virtualFileHelper/pipeline_without_clutters_2_minimize_quotes.yaml");
        JsonNode content_without_clutters_Node = YAMLHelper.YAMLToJsonNode((String)content_without_clutters);
        String result = MetadataClutter.remove((String)content, (boolean)true);
        JsonNode result_Node = YAMLHelper.YAMLToJsonNode((String)result);
        Assert.assertEquals((Object)content_without_clutters_Node.get("metadata"), (Object)result_Node.get("metadata"));
        Assert.assertEquals((Object)content_without_clutters_Node.get("spec"), (Object)result_Node.get("spec"));
    }

    @Test
    public void remove_ContentHasMetadataWithoutClutterTagsAndQuotes_CleanedContent() throws IOException {
        String content = this.load("utils/virtualFileHelper/pipeline_with_clutters_2.yaml");
        String content_without_clutters = this.load("utils/virtualFileHelper/pipeline_without_clutters_2_with_quotes.yaml");
        JsonNode content_without_clutters_Node = YAMLHelper.YAMLToJsonNode((String)content_without_clutters);
        String result = MetadataClutter.remove((String)content, (boolean)false);
        JsonNode result_Node = YAMLHelper.YAMLToJsonNode((String)result);
        Assert.assertEquals((Object)content_without_clutters_Node.get("metadata"), (Object)result_Node.get("metadata"));
        Assert.assertEquals((Object)content_without_clutters_Node.get("spec"), (Object)result_Node.get("spec"));
    }
}

