/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.redhat.devtools.intellij.common.FixtureBaseTest;
import com.redhat.devtools.intellij.common.utils.StringHelper;
import java.io.IOException;
import org.jetbrains.yaml.YAMLFileType;
import org.junit.Assert;
import org.junit.Test;

public class StringHelperTest
extends FixtureBaseTest {
    @Test
    public void GetUnquotedValueFromPsi_DoubleQuotedValue_ValueWithoutQuotes() throws IOException {
        String content = "\"foo\"";
        PsiFile psiFile = this.myFixture.configureByText((FileType)YAMLFileType.YML, content);
        ApplicationManager.getApplication().runReadAction(() -> {
            PsiElement result = psiFile.getFirstChild().getLastChild();
            Assert.assertEquals((Object)"foo", (Object)StringHelper.getUnquotedValueFromPsi((PsiElement)result));
        });
    }

    @Test
    public void GetUnquotedValueFromPsi_SingleQuotedValue_ValueWithoutQuotes() throws IOException {
        String content = "'foo'";
        PsiFile psiFile = this.myFixture.configureByText((FileType)YAMLFileType.YML, content);
        ApplicationManager.getApplication().runReadAction(() -> {
            PsiElement result = psiFile.getFirstChild().getLastChild();
            Assert.assertEquals((Object)"foo", (Object)StringHelper.getUnquotedValueFromPsi((PsiElement)result));
        });
    }

    @Test
    public void GetUnquotedValueFromPsi_UnquotedValue_ValueAsIs() throws IOException {
        String content = "foo";
        PsiFile psiFile = this.myFixture.configureByText((FileType)YAMLFileType.YML, content);
        ApplicationManager.getApplication().runReadAction(() -> {
            PsiElement result = psiFile.getFirstChild().getLastChild();
            Assert.assertEquals((Object)"foo", (Object)StringHelper.getUnquotedValueFromPsi((PsiElement)result));
        });
    }
}

