/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.kubernetes;

import com.redhat.devtools.intellij.common.kubernetes.ClusterHelper;
import com.redhat.devtools.intellij.common.kubernetes.ClusterInfo;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.VersionInfo;
import io.fabric8.openshift.client.OpenShiftClient;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ClusterHelperTest {
    @Test
    public void testKubernetesCluster() {
        VersionInfo versionInfo = (VersionInfo)Mockito.mock(VersionInfo.class);
        Mockito.when((Object)versionInfo.getGitVersion()).thenReturn((Object)"1.20.0");
        KubernetesClient client = (KubernetesClient)Mockito.mock(KubernetesClient.class);
        Mockito.when((Object)client.getKubernetesVersion()).thenReturn((Object)versionInfo);
        ClusterInfo info = ClusterHelper.getClusterInfo((KubernetesClient)client);
        Assert.assertEquals((Object)"1.20.0", (Object)info.getKubernetesVersion());
        Assert.assertFalse((boolean)info.isOpenshift());
        Assert.assertEquals((Object)"", (Object)info.getOpenshiftVersion());
    }

    @Test
    public void testOCP4NormalUserCluster() {
        OpenShiftClient oclient = (OpenShiftClient)Mockito.mock(OpenShiftClient.class);
        Mockito.when((Object)oclient.getVersion()).thenReturn(null);
        Mockito.when((Object)oclient.isSupported()).thenReturn((Object)true);
        VersionInfo versionInfo = (VersionInfo)Mockito.mock(VersionInfo.class);
        Mockito.when((Object)versionInfo.getGitVersion()).thenReturn((Object)"1.20.0");
        KubernetesClient client = (KubernetesClient)Mockito.mock(KubernetesClient.class);
        Mockito.when((Object)((OpenShiftClient)client.adapt(OpenShiftClient.class))).thenReturn((Object)oclient);
        Mockito.when((Object)client.getKubernetesVersion()).thenReturn((Object)versionInfo);
        ClusterInfo info = ClusterHelper.getClusterInfo((KubernetesClient)client);
        Assert.assertEquals((Object)"1.20.0", (Object)info.getKubernetesVersion());
        Assert.assertTrue((boolean)info.isOpenshift());
        Assert.assertEquals((Object)"", (Object)info.getOpenshiftVersion());
    }

    @Test
    public void testOCP3OrOCP4AdminUserCluster() {
        VersionInfo oversionInfo = (VersionInfo)Mockito.mock(VersionInfo.class);
        Mockito.when((Object)oversionInfo.getMajor()).thenReturn((Object)"4");
        Mockito.when((Object)oversionInfo.getMinor()).thenReturn((Object)"7.0");
        OpenShiftClient oclient = (OpenShiftClient)Mockito.mock(OpenShiftClient.class);
        Mockito.when((Object)oclient.getVersion()).thenReturn((Object)oversionInfo);
        Mockito.when((Object)oclient.isSupported()).thenReturn((Object)true);
        VersionInfo versionInfo = (VersionInfo)Mockito.mock(VersionInfo.class);
        Mockito.when((Object)versionInfo.getGitVersion()).thenReturn((Object)"1.20.0");
        KubernetesClient client = (KubernetesClient)Mockito.mock(KubernetesClient.class);
        Mockito.when((Object)((OpenShiftClient)client.adapt(OpenShiftClient.class))).thenReturn((Object)oclient);
        Mockito.when((Object)client.getKubernetesVersion()).thenReturn((Object)versionInfo);
        ClusterInfo info = ClusterHelper.getClusterInfo((KubernetesClient)client);
        Assert.assertEquals((Object)"1.20.0", (Object)info.getKubernetesVersion());
        Assert.assertTrue((boolean)info.isOpenshift());
        Assert.assertEquals((Object)"4.7.0", (Object)info.getOpenshiftVersion());
    }

    @Test
    public void isOpenShift_should_return_true_if_isSupported() {
        OpenShiftClient oclient = (OpenShiftClient)Mockito.mock(OpenShiftClient.class);
        ((OpenShiftClient)Mockito.doReturn((Object)true).when((Object)oclient)).isSupported();
        KubernetesClient client = (KubernetesClient)Mockito.mock(KubernetesClient.class);
        Mockito.when((Object)((OpenShiftClient)client.adapt(OpenShiftClient.class))).thenReturn((Object)oclient);
        boolean isOpenShift = ClusterHelper.isOpenShift((KubernetesClient)client);
        Assertions.assertThat((boolean)isOpenShift).isTrue();
    }

    @Test
    public void isOpenShift_should_return_false_if_isSupported_throws() {
        OpenShiftClient oclient = (OpenShiftClient)Mockito.mock(OpenShiftClient.class);
        ((OpenShiftClient)Mockito.doThrow(KubernetesClientException.class).when((Object)oclient)).isSupported();
        KubernetesClient client = (KubernetesClient)Mockito.mock(KubernetesClient.class);
        Mockito.when((Object)((OpenShiftClient)client.adapt(OpenShiftClient.class))).thenReturn((Object)oclient);
        boolean isOpenShift = ClusterHelper.isOpenShift((KubernetesClient)client);
        Assertions.assertThat((boolean)isOpenShift).isFalse();
    }

    @Test
    public void isOpenShift_should_return_true_if_isSupported_throws_unauthorized() {
        OpenShiftClient oclient = (OpenShiftClient)Mockito.mock(OpenShiftClient.class);
        KubernetesClientException e = new KubernetesClientException("ouch", 401, null);
        ((OpenShiftClient)Mockito.doThrow((Throwable[])new Throwable[]{e}).when((Object)oclient)).isSupported();
        KubernetesClient client = (KubernetesClient)Mockito.mock(KubernetesClient.class);
        Mockito.when((Object)((OpenShiftClient)client.adapt(OpenShiftClient.class))).thenReturn((Object)oclient);
        boolean isOpenShift = ClusterHelper.isOpenShift((KubernetesClient)client);
        Assertions.assertThat((boolean)isOpenShift).isTrue();
    }
}

