/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.redhat.devtools.intellij.common.utils.DateHelper;
import java.time.Instant;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DateHelperTest {
    private static Instant startTime;

    @BeforeClass
    public static void init() {
        startTime = Instant.parse("2020-04-09T07:52:37Z");
    }

    @Test
    public void shouldOnlyPrintSeconds() {
        Instant endTime = Instant.parse("2020-04-09T07:52:57Z");
        String res = DateHelper.humanizeDate((Instant)startTime, (Instant)endTime);
        Assert.assertEquals((Object)res, (Object)"20 s ");
    }

    @Test
    public void shouldOnlyPrintMinutesAndSeconds() {
        Instant endTime = Instant.parse("2020-04-09T07:55:49Z");
        String res = DateHelper.humanizeDate((Instant)startTime, (Instant)endTime);
        Assert.assertEquals((Object)res, (Object)"3 m 12 s ");
    }

    @Test
    public void shouldOnlyPrintHoursAndMinutes() {
        Instant endTime = Instant.parse("2020-04-09T18:23:49Z");
        String res = DateHelper.humanizeDate((Instant)startTime, (Instant)endTime);
        Assert.assertEquals((Object)res, (Object)"10 h 31 m ");
    }

    @Test
    public void shouldOnlyPrintHoursAndMinutesWith0Minutes() {
        Instant endTime = Instant.parse("2020-04-09T15:52:49Z");
        String res = DateHelper.humanizeDate((Instant)startTime, (Instant)endTime);
        Assert.assertEquals((Object)res, (Object)"8 h 0 m ");
    }

    @Test
    public void shouldOnlyPrintDaysAndHours() {
        Instant endTime = Instant.parse("2020-04-19T04:22:11Z");
        String res = DateHelper.humanizeDate((Instant)startTime, (Instant)endTime);
        Assert.assertEquals((Object)res, (Object)"9 d 20 h ");
    }

    @Test
    public void shouldOnlyPrintDaysAndHoursWith0Hours() {
        Instant endTime = Instant.parse("2020-04-19T07:55:11Z");
        String res = DateHelper.humanizeDate((Instant)startTime, (Instant)endTime);
        Assert.assertEquals((Object)res, (Object)"10 d 0 h ");
    }

    @Test
    public void shouldOnlyPrintDaysAndHoursIfDifferenceIsXXDays() {
        Instant endTime = Instant.parse("2020-06-19T04:22:11Z");
        String res = DateHelper.humanizeDate((Instant)startTime, (Instant)endTime);
        Assert.assertEquals((Object)res, (Object)"70 d 20 h ");
    }

    @Test
    public void shouldOnlyPrintDaysIfDifferenceIsXXXDays() {
        Instant endTime = Instant.parse("2021-04-19T04:22:11Z");
        String res = DateHelper.humanizeDate((Instant)startTime, (Instant)endTime);
        Assert.assertEquals((Object)res, (Object)"374 d ");
    }

    @Test
    public void shouldOnlyPrint0SecondsIfStartIsOlderThanEnd() {
        Instant endTime = Instant.parse("2020-04-09T05:52:57Z");
        String res = DateHelper.humanizeDate((Instant)startTime, (Instant)endTime);
        Assert.assertEquals((Object)res, (Object)"0 s ");
    }
}

