/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils.model;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.redhat.devtools.intellij.common.model.GenericResource;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GenericResourceDeserializerTest {
    private ObjectMapper mapper;

    @Before
    public void setUp() {
        this.mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    }

    @Test
    public void Convert_ResourceHasNoName_Throws() {
        try {
            String yaml = this.load("resource_without_name.yaml");
            this.mapper.readValue(yaml, GenericResource.class);
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getLocalizedMessage().contains("Resource configuration not valid. Resource name is missing or invalid."));
        }
    }

    @Test
    public void Convert_ResourceHasNullName_Throws() {
        try {
            String yaml = this.load("resource_with_null_name.yaml");
            this.mapper.readValue(yaml, GenericResource.class);
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getLocalizedMessage().contains("Resource configuration not valid. Resource name is missing or invalid."));
        }
    }

    @Test
    public void Convert_ResourceHasNoKind_Throws() {
        try {
            this.mapper.readValue(this.load("resource_without_kind.yaml"), GenericResource.class);
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getLocalizedMessage().contains("Resource configuration not valid. Resource kind is missing or invalid."));
        }
    }

    @Test
    public void Convert_ResourceHasNullKind_Throws() {
        try {
            this.mapper.readValue(this.load("resource_with_null_kind.yaml"), GenericResource.class);
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getLocalizedMessage().contains("Resource configuration not valid. Resource kind is missing or invalid."));
        }
    }

    @Test
    public void Convert_ResourceHasNoApiVersion_Throws() {
        try {
            this.mapper.readValue(this.load("resource_without_apiversion.yaml"), GenericResource.class);
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getLocalizedMessage().contains("Resource configuration not valid. ApiVersion is missing or invalid."));
        }
    }

    @Test
    public void Convert_ResourceHasNullApiVersion_Throws() {
        try {
            this.mapper.readValue(this.load("resource_with_null_apiversion.yaml"), GenericResource.class);
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getLocalizedMessage().contains("Resource configuration not valid. ApiVersion is missing or invalid."));
        }
    }

    @Test
    public void Convert_ResourceHasNoMetadataSection_Throws() {
        try {
            this.mapper.readValue(this.load("resource_without_metadata.yaml"), GenericResource.class);
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getLocalizedMessage().contains("Resource configuration not valid. Metadata field is missing or invalid."));
        }
    }

    @Test
    public void Convert_ResourceHasNullMetadataSection_Throws() {
        try {
            this.mapper.readValue(this.load("resource_with_null_metadata.yaml"), GenericResource.class);
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getLocalizedMessage().contains("Resource configuration not valid. Metadata field is missing or invalid."));
        }
    }

    @Test
    public void Convert_ResourceHasNoSpec_Throws() {
        try {
            this.mapper.readValue(this.load("resource_without_spec.yaml"), GenericResource.class);
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getLocalizedMessage().contains("Resource configuration not valid. Spec field is missing or invalid."));
        }
    }

    @Test
    public void Convert_ResourceHasNullSpec_Throws() {
        try {
            this.mapper.readValue(this.load("resource_with_null_spec.yaml"), GenericResource.class);
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getLocalizedMessage().contains("Resource configuration not valid. Spec field is missing or invalid."));
        }
    }

    @Test
    public void Convert_ResourceIsValid_GenericResource() throws IOException {
        GenericResource genericResource = (GenericResource)this.mapper.readValue(this.load("resource.yaml"), GenericResource.class);
        Assert.assertEquals((Object)genericResource.getApiVersion(), (Object)"tekton.dev/v1beta1");
        Assert.assertEquals((Object)genericResource.getKind(), (Object)"Pipeline");
        Assert.assertEquals((Object)genericResource.getName(), (Object)"foo");
        Assert.assertTrue((genericResource.getMetadata() != null ? 1 : 0) != 0);
        Assert.assertTrue((genericResource.getSpec() != null ? 1 : 0) != 0);
    }

    private String load(String name) throws IOException {
        return IOUtils.toString((URL)GenericResourceDeserializerTest.class.getResource("/model/" + name), (Charset)StandardCharsets.UTF_8);
    }
}

